/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String gp;
    private final String dC;
    private final String Pd;
    private final String Pe;
    private final String zzcvf;
    private final String Pf;
    private final Uri Pg;
    private final Uri Ph;
    private final Uri Pi;
    private final boolean Pj;
    private final boolean Pk;
    private final String Pl;
    private final int Pm;
    private final int Pn;
    private final int Po;
    private final boolean Pp;
    private final boolean Pq;
    private final String Pr;
    private final String Ps;
    private final String Pt;
    private final boolean zzbse;
    private final boolean Pu;
    private final boolean Pv;
    private final String Pw;
    private final boolean Px;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.gp = game.getApplicationId();
        this.Pd = game.getPrimaryCategory();
        this.Pe = game.getSecondaryCategory();
        this.zzcvf = game.getDescription();
        this.Pf = game.getDeveloperName();
        this.dC = game.getDisplayName();
        this.Pg = game.getIconImageUri();
        this.Pr = game.getIconImageUrl();
        this.Ph = game.getHiResImageUri();
        this.Ps = game.getHiResImageUrl();
        this.Pi = game.getFeaturedImageUri();
        this.Pt = game.getFeaturedImageUrl();
        this.Pj = game.zzbey();
        this.Pk = game.zzbfa();
        this.Pl = game.zzbfb();
        this.Pm = 1;
        this.Pn = game.getAchievementTotalCount();
        this.Po = game.getLeaderboardCount();
        this.Pp = game.isRealTimeMultiplayerEnabled();
        this.Pq = game.isTurnBasedMultiplayerEnabled();
        this.zzbse = game.isMuted();
        this.Pu = game.zzbez();
        this.Pv = game.areSnapshotsEnabled();
        this.Pw = game.getThemeColor();
        this.Px = game.hasGamepadSupport();
    }

    GameEntity(int n, String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n2, int n3, int n4, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.mVersionCode = n;
        this.gp = string;
        this.dC = string2;
        this.Pd = string3;
        this.Pe = string4;
        this.zzcvf = string5;
        this.Pf = string6;
        this.Pg = uri;
        this.Pr = string8;
        this.Ph = uri2;
        this.Ps = string9;
        this.Pi = uri3;
        this.Pt = string10;
        this.Pj = bl;
        this.Pk = bl2;
        this.Pl = string7;
        this.Pm = n2;
        this.Pn = n3;
        this.Po = n4;
        this.Pp = bl3;
        this.Pq = bl4;
        this.zzbse = bl5;
        this.Pu = bl6;
        this.Pv = bl7;
        this.Pw = string11;
        this.Px = bl8;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.gp;
    }

    @Override
    public String getDisplayName() {
        return this.dC;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.dC, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.Pd;
    }

    @Override
    public String getSecondaryCategory() {
        return this.Pe;
    }

    @Override
    public String getDescription() {
        return this.zzcvf;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvf, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.Pf;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Pf, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Pg;
    }

    @Override
    public String getIconImageUrl() {
        return this.Pr;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Ph;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Ps;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.Pi;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.Pt;
    }

    @Override
    public boolean isMuted() {
        return this.zzbse;
    }

    @Override
    public boolean zzbez() {
        return this.Pu;
    }

    @Override
    public boolean zzbey() {
        return this.Pj;
    }

    @Override
    public boolean zzbfa() {
        return this.Pk;
    }

    @Override
    public String zzbfb() {
        return this.Pl;
    }

    public int zzbfc() {
        return this.Pm;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.Pn;
    }

    @Override
    public int getLeaderboardCount() {
        return this.Po;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.Pp;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.Pq;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.Pv;
    }

    @Override
    public String getThemeColor() {
        return this.Pw;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.Px;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzaa.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzbey(), game.zzbfa(), game.zzbfb(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzbez(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzaa.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzaa.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzaa.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzaa.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzaa.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzaa.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzaa.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzaa.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzaa.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzaa.equal((Object)game2.zzbey(), (Object)game.zzbey()) && zzaa.equal((Object)game2.zzbfa(), (Object)game.zzbfa()) && zzaa.equal((Object)game2.zzbfb(), (Object)game.zzbfb()) && zzaa.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzaa.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzaa.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzaa.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzaa.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzaa.equal((Object)game2.zzbez(), (Object)game.zzbez()) ? 1 : 0)) && zzaa.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzaa.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzaa.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzaa.zzx((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzbey()).zzg("InstanceInstalled", (Object)game.zzbfa()).zzg("InstancePackageName", (Object)game.zzbfb()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasu()) {
            GameEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.gp);
            parcel.writeString(this.dC);
            parcel.writeString(this.Pd);
            parcel.writeString(this.Pe);
            parcel.writeString(this.zzcvf);
            parcel.writeString(this.Pf);
            parcel.writeString(this.Pg == null ? null : this.Pg.toString());
            parcel.writeString(this.Ph == null ? null : this.Ph.toString());
            parcel.writeString(this.Pi == null ? null : this.Pi.toString());
            parcel.writeInt(this.Pj ? 1 : 0);
            parcel.writeInt(this.Pk ? 1 : 0);
            parcel.writeString(this.Pl);
            parcel.writeInt(this.Pm);
            parcel.writeInt(this.Pn);
            parcel.writeInt(this.Po);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzku(Parcel parcel) {
            boolean bl = GameEntity.zzf(GameEntity.zzast());
            if (bl || GameEntity.zzhk((String)GameEntity.class.getCanonicalName())) {
                return super.zzku(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            Object var23_23 = null;
            Object var24_24 = null;
            Object var25_25 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            Object var29_29 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzku(parcel);
        }
    }
}

