/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames Ql;
    private final PlayerLevelInfo PU;
    private final MostRecentGameInfoRef Qm;

    public PlayerRef(DataHolder dataHolder, int n) {
        this(dataHolder, n, null);
    }

    public PlayerRef(DataHolder dataHolder, int n, String string) {
        super(dataHolder, n);
        this.Ql = new PlayerColumnNames(string);
        this.Qm = new MostRecentGameInfoRef(dataHolder, n, this.Ql);
        if (this.zzbfm()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.Ql.VG);
            int n3 = this.getInteger(this.Ql.VJ);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.Ql.VH), this.getLong(this.Ql.VI));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.Ql.VI), this.getLong(this.Ql.VK));
            }
            this.PU = new PlayerLevelInfo(this.getLong(this.Ql.VF), this.getLong(this.Ql.VL), playerLevel, playerLevel2);
        } else {
            this.PU = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.Ql.Vw);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.Ql.Vx);
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza(this.Ql.Vx, charArrayBuffer);
    }

    @Override
    public String zzbff() {
        return this.getString(this.Ql.VV);
    }

    @Override
    public String getName() {
        return this.getString(this.Ql.name);
    }

    @Override
    public boolean zzbfg() {
        return this.getBoolean(this.Ql.VU);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzhf(this.Ql.Vy);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.Ql.Vz);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzhf(this.Ql.VA);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.Ql.VB);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.Ql.VC);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzhe(this.Ql.VE) || this.zzhg(this.Ql.VE)) {
            return -1L;
        }
        return this.getLong(this.Ql.VE);
    }

    @Override
    public int zzbfh() {
        return this.getInteger(this.Ql.VD);
    }

    @Override
    public boolean zzbfi() {
        return this.getBoolean(this.Ql.VN);
    }

    @Override
    public String getTitle() {
        return this.getString(this.Ql.title);
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        this.zza(this.Ql.title, charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.PU;
    }

    @Override
    public MostRecentGameInfo zzbfj() {
        if (this.zzhg(this.Ql.VO)) {
            return null;
        }
        return this.Qm;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzhf(this.Ql.VW);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.Ql.VX);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzhf(this.Ql.VY);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.Ql.VZ);
    }

    @Override
    public int zzbfk() {
        return this.getInteger(this.Ql.Wa);
    }

    @Override
    public long zzbfl() {
        return this.getLong(this.Ql.Wb);
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean(this.Ql.Wc);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntity playerEntity = (PlayerEntity)((Player)this.freeze());
        playerEntity.writeToParcel(parcel, n);
    }

    private boolean zzbfm() {
        if (this.zzhg(this.Ql.VF)) {
            return false;
        }
        return this.getLong(this.Ql.VF) != -1L;
    }
}

