/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;

public final class AchievementEntity
extends AbstractSafeParcelable
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String Qn;
    private final int iq;
    private final String mName;
    private final String zzcvf;
    private final Uri Qo;
    private final String Qp;
    private final Uri Qq;
    private final String Qr;
    private final int Qs;
    private final String Qt;
    private final PlayerEntity Qu;
    private final int mState;
    private final int Qv;
    private final String Qw;
    private final long Qx;
    private final long Qy;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.Qn = achievement.getAchievementId();
        this.iq = achievement.getType();
        this.mName = achievement.getName();
        this.zzcvf = achievement.getDescription();
        this.Qo = achievement.getUnlockedImageUri();
        this.Qp = achievement.getUnlockedImageUrl();
        this.Qq = achievement.getRevealedImageUri();
        this.Qr = achievement.getRevealedImageUrl();
        this.Qu = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.Qx = achievement.getLastUpdatedTimestamp();
        this.Qy = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.Qs = achievement.getTotalSteps();
            this.Qt = achievement.getFormattedTotalSteps();
            this.Qv = achievement.getCurrentSteps();
            this.Qw = achievement.getFormattedCurrentSteps();
        } else {
            this.Qs = 0;
            this.Qt = null;
            this.Qv = 0;
            this.Qw = null;
        }
        zzb.zzu((Object)this.Qn);
        zzb.zzu((Object)this.zzcvf);
    }

    AchievementEntity(int n, String string, int n2, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n3, String string6, PlayerEntity playerEntity, int n4, int n5, String string7, long l, long l2) {
        this.mVersionCode = n;
        this.Qn = string;
        this.iq = n2;
        this.mName = string2;
        this.zzcvf = string3;
        this.Qo = uri;
        this.Qp = string4;
        this.Qq = uri2;
        this.Qr = string5;
        this.Qs = n3;
        this.Qt = string6;
        this.Qu = playerEntity;
        this.mState = n4;
        this.Qv = n5;
        this.Qw = string7;
        this.Qx = l;
        this.Qy = l2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.Qn;
    }

    @Override
    public int getType() {
        return this.iq;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzcvf;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvf, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.Qo;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.Qp;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.Qq;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.Qr;
    }

    public int zzbfs() {
        return this.Qs;
    }

    @Override
    public int getTotalSteps() {
        zzb.zzbn((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbfs();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzbn((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbft();
    }

    public String zzbft() {
        return this.Qt;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        zzb.zzbn((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.Qt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return this.Qu;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzbn((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbfu();
    }

    public int zzbfu() {
        return this.Qv;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzbn((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbfv();
    }

    public String zzbfv() {
        return this.Qw;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        zzb.zzbn((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.Qw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Qx;
    }

    @Override
    public long getXpValue() {
        return this.Qy;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzaa.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object object) {
        return AchievementEntity.zza(this, object);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzaa.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzaa.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzaa.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzaa.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzaa.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzaa.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzaa.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzaa.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzaa.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzaa.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzaa.zza zza2 = zzaa.zzx((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntityCreator.zza(this, parcel, n);
    }
}

