/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;

public final class EventEntity
extends AbstractSafeParcelable
implements Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String QW;
    private final String mName;
    private final String zzcvf;
    private final Uri Pg;
    private final String Pr;
    private final PlayerEntity Qu;
    private final long zzcve;
    private final String QX;
    private final boolean zzaqu;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.QW = event.getEventId();
        this.mName = event.getName();
        this.zzcvf = event.getDescription();
        this.Pg = event.getIconImageUri();
        this.Pr = event.getIconImageUrl();
        this.Qu = (PlayerEntity)event.getPlayer().freeze();
        this.zzcve = event.getValue();
        this.QX = event.getFormattedValue();
        this.zzaqu = event.isVisible();
    }

    EventEntity(int n, String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.mVersionCode = n;
        this.QW = string;
        this.mName = string2;
        this.zzcvf = string3;
        this.Pg = uri;
        this.Pr = string4;
        this.Qu = new PlayerEntity(player);
        this.zzcve = l;
        this.QX = string5;
        this.zzaqu = bl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.QW;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzcvf;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvf, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Pg;
    }

    @Override
    public String getIconImageUrl() {
        return this.Pr;
    }

    @Override
    public Player getPlayer() {
        return this.Qu;
    }

    @Override
    public long getValue() {
        return this.zzcve;
    }

    @Override
    public String getFormattedValue() {
        return this.QX;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.QX, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public boolean isVisible() {
        return this.zzaqu;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzaa.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzaa.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzaa.equal((Object)event2.getName(), (Object)event.getName()) && zzaa.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzaa.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzaa.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzaa.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzaa.equal((Object)event2.getValue(), (Object)event.getValue()) && zzaa.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzaa.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzaa.zzx((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        EventEntityCreator.zza(this, parcel, n);
    }
}

