/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity Vh;
    private final String bP;
    private final long WR;
    private final int WS;
    private final ParticipantEntity WT;
    private final ArrayList<ParticipantEntity> WU;
    private final int WV;
    private final int WW;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.Vh = new GameEntity(invitation.getGame());
        this.bP = invitation.getInvitationId();
        this.WR = invitation.getCreationTimestamp();
        this.WS = invitation.getInvitationType();
        this.WV = invitation.getVariant();
        this.WW = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.WU = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.WU.add((ParticipantEntity)participant2.freeze());
        }
        zzab.zzb(participant, (Object)"Must have a valid inviter!");
        this.WT = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int n, GameEntity gameEntity, String string, long l, int n2, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n3, int n4) {
        this.mVersionCode = n;
        this.Vh = gameEntity;
        this.bP = string;
        this.WR = l;
        this.WS = n2;
        this.WT = participantEntity;
        this.WU = arrayList;
        this.WV = n3;
        this.WW = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.Vh;
    }

    @Override
    public String getInvitationId() {
        return this.bP;
    }

    @Override
    public Participant getInviter() {
        return this.WT;
    }

    @Override
    public long getCreationTimestamp() {
        return this.WR;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.WU);
    }

    @Override
    public int getInvitationType() {
        return this.WS;
    }

    @Override
    public int getVariant() {
        return this.WV;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.WW;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzaa.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzaa.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzaa.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzaa.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzaa.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzaa.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzaa.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzaa.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzaa.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzaa.zzx((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasu()) {
            InvitationEntityCreator.zza(this, parcel, n);
        } else {
            this.Vh.writeToParcel(parcel, n);
            parcel.writeString(this.bP);
            parcel.writeLong(this.WR);
            parcel.writeInt(this.WS);
            this.WT.writeToParcel(parcel, n);
            int n2 = this.WU.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.WU.get(i).writeToParcel(parcel, n);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzlo(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzf(InvitationEntity.zzast());
            if (bl || InvitationEntity.zzhk((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzlo(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            boolean bl2 = false;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, -1, 0);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzlo(parcel);
        }
    }
}

