/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import java.util.ArrayList;

public final class InvitationRef
extends zzc
implements Invitation {
    private final Game Wp;
    private final ParticipantRef WX;
    private final ArrayList<Participant> WU;

    InvitationRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.Wp = new GameRef(dataHolder, n);
        this.WU = new ArrayList(n2);
        ParticipantRef participantRef = null;
        String string = this.getString("external_inviter_id");
        for (int i = 0; i < n2; ++i) {
            ParticipantRef participantRef2 = new ParticipantRef(this.tu, this.vX + i);
            if (participantRef2.getParticipantId().equals(string)) {
                participantRef = participantRef2;
            }
            this.WU.add(participantRef2);
        }
        this.WX = (ParticipantRef)zzab.zzb(participantRef, (Object)"Must have a valid inviter!");
    }

    @Override
    public Game getGame() {
        return this.Wp;
    }

    @Override
    public String getInvitationId() {
        return this.getString("external_invitation_id");
    }

    @Override
    public Participant getInviter() {
        return this.WX;
    }

    @Override
    public long getCreationTimestamp() {
        long l = this.getLong("creation_timestamp");
        long l2 = this.getLong("last_modified_timestamp");
        return Math.max(l, l2);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return this.WU;
    }

    @Override
    public int getInvitationType() {
        return this.getInteger("type");
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return 0;
        }
        return this.getInteger("automatch_max_players");
    }

    public Invitation freeze() {
        return new InvitationEntity(this);
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    public boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        InvitationEntity invitationEntity = (InvitationEntity)((Invitation)this.freeze());
        invitationEntity.writeToParcel(parcel, n);
    }
}

