/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
extends AbstractSafeParcelable
implements Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final int mVersionCode;
    private final String Sl;
    private final long XF;
    private final long XG;
    private final byte[] XH;
    private final int mState;
    private final String QW;

    public MilestoneEntity(Milestone milestone) {
        this.mVersionCode = 4;
        this.Sl = milestone.getMilestoneId();
        this.XF = milestone.getCurrentProgress();
        this.XG = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.QW = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.XH = null;
        } else {
            this.XH = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.XH, 0, byArray.length);
        }
    }

    MilestoneEntity(int n, String string, long l, long l2, byte[] byArray, int n2, String string2) {
        this.mVersionCode = n;
        this.Sl = string;
        this.XF = l;
        this.XG = l2;
        this.XH = byArray;
        this.mState = n2;
        this.QW = string2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.QW;
    }

    @Override
    public String getMilestoneId() {
        return this.Sl;
    }

    @Override
    public long getCurrentProgress() {
        return this.XF;
    }

    @Override
    public long getTargetProgress() {
        return this.XG;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.XH;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzaa.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzaa.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzaa.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzaa.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzaa.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzaa.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzaa.zzx((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        MilestoneEntityCreator.zza(this, parcel, n);
    }
}

