/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
extends AbstractSafeParcelable
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity Vh;
    private final String XI;
    private final long XJ;
    private final Uri XK;
    private final String XL;
    private final String zzcvf;
    private final long XM;
    private final long Qx;
    private final Uri mIconUri;
    private final String XN;
    private final String mName;
    private final long XO;
    private final long XP;
    private final int mState;
    private final int iq;
    private final ArrayList<MilestoneEntity> XQ;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.Vh = new GameEntity(quest.getGame());
        this.XI = quest.getQuestId();
        this.XJ = quest.getAcceptedTimestamp();
        this.zzcvf = quest.getDescription();
        this.XK = quest.getBannerImageUri();
        this.XL = quest.getBannerImageUrl();
        this.XM = quest.getEndTimestamp();
        this.mIconUri = quest.getIconImageUri();
        this.XN = quest.getIconImageUrl();
        this.Qx = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.XO = quest.zzbkl();
        this.XP = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.iq = quest.getType();
        List<Milestone> list = quest.zzbkk();
        int n = list.size();
        this.XQ = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.XQ.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int n, GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n2, int n3, ArrayList<MilestoneEntity> arrayList) {
        this.mVersionCode = n;
        this.Vh = gameEntity;
        this.XI = string;
        this.XJ = l;
        this.XK = uri;
        this.XL = string2;
        this.zzcvf = string3;
        this.XM = l2;
        this.Qx = l3;
        this.mIconUri = uri2;
        this.XN = string4;
        this.mName = string5;
        this.XO = l4;
        this.XP = l5;
        this.mState = n2;
        this.iq = n3;
        this.XQ = arrayList;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.XI;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzcvf;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvf, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.mIconUri;
    }

    @Override
    public String getIconImageUrl() {
        return this.XN;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.XK;
    }

    @Override
    public String getBannerImageUrl() {
        return this.XL;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzbkk().get(0);
    }

    @Override
    public List<Milestone> zzbkk() {
        return new ArrayList<Milestone>(this.XQ);
    }

    @Override
    public Game getGame() {
        return this.Vh;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.iq;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.XJ;
    }

    @Override
    public long getEndTimestamp() {
        return this.XM;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Qx;
    }

    @Override
    public long zzbkl() {
        return this.XO;
    }

    @Override
    public long getStartTimestamp() {
        return this.XP;
    }

    @Override
    public boolean isEndingSoon() {
        return this.XO <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzaa.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzbkk(), quest.getName(), quest.zzbkl(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzaa.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzaa.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzaa.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzaa.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzaa.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzaa.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzaa.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzaa.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzaa.equal(quest2.zzbkk(), quest.zzbkk()) && zzaa.equal((Object)quest2.getName(), (Object)quest.getName()) && zzaa.equal((Object)quest2.zzbkl(), (Object)quest.zzbkl()) && zzaa.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzaa.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzaa.zzx((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzbkk()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzbkl()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntityCreator.zza(this, parcel, n);
    }
}

