/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.zzqc;

public final class SnapshotsImpl
implements Snapshots {
    @Override
    public int getMaxDataSize(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbkp();
    }

    @Override
    public int getMaxCoverImageSize(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbkq();
    }

    @Override
    public Intent getSelectSnapshotIntent(GoogleApiClient googleApiClient, String string, boolean bl, boolean bl2, int n) {
        return Games.zzi(googleApiClient).zza(string, bl, bl2, n);
    }

    @Override
    public PendingResult<Snapshots.LoadSnapshotsResult> load(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zzc((zzqc.zza)new LoadImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzf((zzqc.zzb<Snapshots.LoadSnapshotsResult>)this, bl);
            }
        });
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient googleApiClient, SnapshotMetadata snapshotMetadata) {
        return this.open(googleApiClient, snapshotMetadata.getUniqueName(), false);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient googleApiClient, SnapshotMetadata snapshotMetadata, int n) {
        return this.open(googleApiClient, snapshotMetadata.getUniqueName(), false, n);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient googleApiClient, String string, boolean bl) {
        return this.open(googleApiClient, string, bl, -1);
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> open(GoogleApiClient googleApiClient, final String string, final boolean bl, final int n) {
        return googleApiClient.zzd((zzqc.zza)new OpenImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzqc.zzb<Snapshots.OpenSnapshotResult>)this, string, bl, n);
            }
        });
    }

    @Override
    public PendingResult<Snapshots.CommitSnapshotResult> commitAndClose(GoogleApiClient googleApiClient, final Snapshot snapshot, final SnapshotMetadataChange snapshotMetadataChange) {
        return googleApiClient.zzd((zzqc.zza)new CommitImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzqc.zzb<Snapshots.CommitSnapshotResult>)this, snapshot, snapshotMetadataChange);
            }
        });
    }

    @Override
    public void discardAndClose(GoogleApiClient googleApiClient, Snapshot snapshot) {
        Games.zzi(googleApiClient).zza(snapshot);
    }

    @Override
    public PendingResult<Snapshots.DeleteSnapshotResult> delete(GoogleApiClient googleApiClient, final SnapshotMetadata snapshotMetadata) {
        return googleApiClient.zzd((zzqc.zza)new DeleteImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzi((zzqc.zzb<Snapshots.DeleteSnapshotResult>)this, snapshotMetadata.getSnapshotId());
            }
        });
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> resolveConflict(GoogleApiClient googleApiClient, String string, Snapshot snapshot) {
        SnapshotMetadata snapshotMetadata = snapshot.getMetadata();
        SnapshotMetadataChange snapshotMetadataChange = new SnapshotMetadataChange.Builder().fromMetadata(snapshotMetadata).build();
        return this.resolveConflict(googleApiClient, string, snapshotMetadata.getSnapshotId(), snapshotMetadataChange, snapshot.getSnapshotContents());
    }

    @Override
    public PendingResult<Snapshots.OpenSnapshotResult> resolveConflict(GoogleApiClient googleApiClient, final String string, final String string2, final SnapshotMetadataChange snapshotMetadataChange, final SnapshotContents snapshotContents) {
        return googleApiClient.zzd((zzqc.zza)new OpenImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzqc.zzb<Snapshots.OpenSnapshotResult>)this, string, string2, snapshotMetadataChange, snapshotContents);
            }
        });
    }

    @Override
    public SnapshotMetadata getSnapshotFromBundle(Bundle bundle) {
        if (bundle == null || !bundle.containsKey("com.google.android.gms.games.SNAPSHOT_METADATA")) {
            return null;
        }
        SnapshotMetadata snapshotMetadata = (SnapshotMetadata)bundle.getParcelable("com.google.android.gms.games.SNAPSHOT_METADATA");
        return snapshotMetadata;
    }

    private static abstract class DeleteImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.DeleteSnapshotResult> {
        private DeleteImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.DeleteSnapshotResult zzcq(final Status status) {
            return new Snapshots.DeleteSnapshotResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getSnapshotId() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzcq(status);
        }
    }

    private static abstract class CommitImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.CommitSnapshotResult> {
        private CommitImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.CommitSnapshotResult zzcp(final Status status) {
            return new Snapshots.CommitSnapshotResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public SnapshotMetadata getSnapshotMetadata() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzcp(status);
        }
    }

    private static abstract class OpenImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.OpenSnapshotResult> {
        private OpenImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.OpenSnapshotResult zzcs(final Status status) {
            return new Snapshots.OpenSnapshotResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Snapshot getSnapshot() {
                    return null;
                }

                @Override
                public String getConflictId() {
                    return null;
                }

                @Override
                public Snapshot getConflictingSnapshot() {
                    return null;
                }

                @Override
                public SnapshotContents getResolutionSnapshotContents() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzcs(status);
        }
    }

    private static abstract class LoadImpl
    extends Games.BaseGamesApiMethodImpl<Snapshots.LoadSnapshotsResult> {
        private LoadImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Snapshots.LoadSnapshotsResult zzcr(final Status status) {
            return new Snapshots.LoadSnapshotsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public SnapshotMetadataBuffer getSnapshots() {
                    return new SnapshotMetadataBuffer(DataHolder.zzgc((int)14));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzcr(status);
        }
    }
}

