/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long abU;
    private final String abV;
    private final String abW;
    private final long abX;
    private final long abY;
    private final String abZ;
    private final Uri aca;
    private final Uri acb;
    private final PlayerEntity acc;
    private final String acd;
    private final String ace;
    private final String acf;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.abU = leaderboardScore.getRank();
        this.abV = (String)zzac.zzy((Object)leaderboardScore.getDisplayRank());
        this.abW = (String)zzac.zzy((Object)leaderboardScore.getDisplayScore());
        this.abX = leaderboardScore.getRawScore();
        this.abY = leaderboardScore.getTimestampMillis();
        this.abZ = leaderboardScore.getScoreHolderDisplayName();
        this.aca = leaderboardScore.getScoreHolderIconImageUri();
        this.acb = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.acc = player == null ? null : (PlayerEntity)player.freeze();
        this.acd = leaderboardScore.getScoreTag();
        this.ace = leaderboardScore.getScoreHolderIconImageUrl();
        this.acf = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.abU;
    }

    @Override
    public String getDisplayRank() {
        return this.abV;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.abV, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.abW;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.abW, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.abX;
    }

    @Override
    public long getTimestampMillis() {
        return this.abY;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.acc == null) {
            return this.abZ;
        }
        return this.acc.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.acc == null) {
            zzg.zzb((String)this.abZ, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.acc.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.acc == null) {
            return this.aca;
        }
        return this.acc.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.acc == null) {
            return this.ace;
        }
        return this.acc.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.acc == null) {
            return this.acb;
        }
        return this.acc.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.acc == null) {
            return this.acf;
        }
        return this.acc.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.acc;
    }

    @Override
    public String getScoreTag() {
        return this.acd;
    }

    public LeaderboardScore zzbmw() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzab.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzab.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzab.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzab.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzab.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzab.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzab.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzab.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzab.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzab.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzab.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzab.zzx((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzbmw();
    }
}

