/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzbng();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String Y;
        private Long adB;
        private Long adC;
        private BitmapTeleporter adD;
        private Uri adE;

        public Builder setDescription(String string) {
            this.Y = string;
            return this;
        }

        public Builder setPlayedTimeMillis(long l) {
            this.adB = l;
            return this;
        }

        public Builder setProgressValue(long l) {
            this.adC = l;
            return this;
        }

        public Builder setCoverImage(Bitmap bitmap) {
            this.adD = new BitmapTeleporter(bitmap);
            this.adE = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.Y = snapshotMetadata.getDescription();
            this.adB = snapshotMetadata.getPlayedTime();
            this.adC = snapshotMetadata.getProgressValue();
            if (this.adB == -1L) {
                this.adB = null;
            }
            this.adE = snapshotMetadata.getCoverImageUri();
            if (this.adE != null) {
                this.adD = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.Y, this.adB, this.adD, this.adE, this.adC);
        }
    }
}

