/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private String uh;
    private String jh;
    private final Uri WQ;
    private final Uri WR;
    private final long XA;
    private final int XB;
    private final long XC;
    private final String Xb;
    private final String Xc;
    private final String JB;
    private final MostRecentGameInfoEntity XD;
    private final PlayerLevelInfo XE;
    private final boolean XF;
    private final boolean XG;
    private final String XH;
    private final String mName;
    private final Uri XI;
    private final String XJ;
    private final Uri XK;
    private final String XL;
    private final int XM;
    private final long XN;
    private final boolean C;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean bl) {
        this.mVersionCode = 14;
        this.uh = bl ? player.getPlayerId() : null;
        this.jh = player.getDisplayName();
        this.WQ = player.getIconImageUri();
        this.Xb = player.getIconImageUrl();
        this.WR = player.getHiResImageUri();
        this.Xc = player.getHiResImageUrl();
        this.XA = player.getRetrievedTimestamp();
        this.XB = player.zzbhs();
        this.XC = player.getLastPlayedWithTimestamp();
        this.JB = player.getTitle();
        this.XF = player.zzbht();
        MostRecentGameInfo mostRecentGameInfo = player.zzbhu();
        this.XD = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.XE = player.getLevelInfo();
        this.XG = player.zzbhr();
        this.XH = player.zzbhq();
        this.mName = player.getName();
        this.XI = player.getBannerImageLandscapeUri();
        this.XJ = player.getBannerImageLandscapeUrl();
        this.XK = player.getBannerImagePortraitUri();
        this.XL = player.getBannerImagePortraitUrl();
        this.XM = player.zzbhv();
        this.XN = player.zzbhw();
        this.C = player.isMuted();
        if (bl) {
            zzc.zzu((Object)this.uh);
        }
        zzc.zzu((Object)this.jh);
        zzc.zzbs((this.XA > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int n, String string, String string2, Uri uri, Uri uri2, long l, int n2, long l2, String string3, String string4, String string5, MostRecentGameInfoEntity mostRecentGameInfoEntity, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n3, long l3, boolean bl3) {
        this.mVersionCode = n;
        this.uh = string;
        this.jh = string2;
        this.WQ = uri;
        this.Xb = string3;
        this.WR = uri2;
        this.Xc = string4;
        this.XA = l;
        this.XB = n2;
        this.XC = l2;
        this.JB = string5;
        this.XF = bl;
        this.XD = mostRecentGameInfoEntity;
        this.XE = playerLevelInfo;
        this.XG = bl2;
        this.XH = string6;
        this.mName = string7;
        this.XI = uri3;
        this.XJ = string8;
        this.XK = uri4;
        this.XL = string9;
        this.XM = n3;
        this.XN = l3;
        this.C = bl3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.uh;
    }

    @Override
    public String getDisplayName() {
        return this.jh;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.jh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String zzbhq() {
        return this.XH;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzbhr() {
        return this.XG;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.WQ;
    }

    @Override
    public String getIconImageUrl() {
        return this.Xb;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.WR;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Xc;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.XA;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.XC;
    }

    @Override
    public int zzbhs() {
        return this.XB;
    }

    @Override
    public boolean zzbht() {
        return this.XF;
    }

    @Override
    public String getTitle() {
        return this.JB;
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.JB, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.XE;
    }

    @Override
    public MostRecentGameInfo zzbhu() {
        return this.XD;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.XI;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.XJ;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.XK;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.XL;
    }

    @Override
    public int zzbhv() {
        return this.XM;
    }

    @Override
    public long zzbhw() {
        return this.XN;
    }

    @Override
    public boolean isMuted() {
        return this.C;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzz.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzbhr(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzbhq(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzbhv(), player.zzbhw(), player.isMuted()});
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzz.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzz.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzz.equal((Object)player2.zzbhr(), (Object)player.zzbhr()) && zzz.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzz.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzz.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzz.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzz.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzz.equal((Object)player2.zzbhq(), (Object)player.zzbhq()) && zzz.equal((Object)player2.getName(), (Object)player.getName()) && zzz.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzz.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzz.equal((Object)player2.zzbhv(), (Object)player.zzbhv()) && zzz.equal((Object)player2.zzbhw(), (Object)player.zzbhw()) && zzz.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzz.zzx((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzbhr()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzbhq()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzbhv()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzbhw()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzawa()) {
            PlayerEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.uh);
            parcel.writeString(this.jh);
            parcel.writeString(this.WQ == null ? null : this.WQ.toString());
            parcel.writeString(this.WR == null ? null : this.WR.toString());
            parcel.writeLong(this.XA);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzll(Parcel parcel) {
            boolean bl = PlayerEntity.zzf(PlayerEntity.zzavz());
            if (bl || PlayerEntity.zzhu((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzll(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            Object var16_14 = null;
            Object var17_15 = null;
            Object var18_16 = null;
            Object var19_17 = null;
            Object var20_18 = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Object var23_21 = null;
            Object var24_22 = null;
            Object var25_23 = null;
            Object var26_24 = null;
            int n2 = -1;
            long l3 = -1L;
            boolean bl4 = false;
            return new PlayerEntity(14, string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzll(parcel);
        }
    }
}

