/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames XV;
    private final PlayerLevelInfo XE;
    private final MostRecentGameInfoRef XW;

    public PlayerRef(DataHolder dataHolder, int n) {
        this(dataHolder, n, null);
    }

    public PlayerRef(DataHolder dataHolder, int n, String string) {
        super(dataHolder, n);
        this.XV = new PlayerColumnNames(string);
        this.XW = new MostRecentGameInfoRef(dataHolder, n, this.XV);
        if (this.zzbhx()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.XV.ads);
            int n3 = this.getInteger(this.XV.adv);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.XV.adt), this.getLong(this.XV.adu));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.XV.adu), this.getLong(this.XV.adw));
            }
            this.XE = new PlayerLevelInfo(this.getLong(this.XV.adr), this.getLong(this.XV.adx), playerLevel, playerLevel2);
        } else {
            this.XE = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.XV.adi);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.XV.adj);
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza(this.XV.adj, charArrayBuffer);
    }

    @Override
    public String zzbhq() {
        return this.getString(this.XV.adH);
    }

    @Override
    public String getName() {
        return this.getString(this.XV.name);
    }

    @Override
    public boolean zzbhr() {
        return this.getBoolean(this.XV.adG);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzhp(this.XV.adk);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.XV.adl);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzhp(this.XV.adm);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.XV.adn);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.XV.ado);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzho(this.XV.adq) || this.zzhq(this.XV.adq)) {
            return -1L;
        }
        return this.getLong(this.XV.adq);
    }

    @Override
    public int zzbhs() {
        return this.getInteger(this.XV.adp);
    }

    @Override
    public boolean zzbht() {
        return this.getBoolean(this.XV.adz);
    }

    @Override
    public String getTitle() {
        return this.getString(this.XV.title);
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        this.zza(this.XV.title, charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.XE;
    }

    @Override
    public MostRecentGameInfo zzbhu() {
        if (this.zzhq(this.XV.adA)) {
            return null;
        }
        return this.XW;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzhp(this.XV.adI);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.XV.adJ);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzhp(this.XV.adK);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.XV.adL);
    }

    @Override
    public int zzbhv() {
        return this.getInteger(this.XV.adM);
    }

    @Override
    public long zzbhw() {
        return this.getLong(this.XV.adN);
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean(this.XV.adO);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntity playerEntity = (PlayerEntity)((Player)this.freeze());
        playerEntity.writeToParcel(parcel, n);
    }

    private boolean zzbhx() {
        if (this.zzhq(this.XV.adr)) {
            return false;
        }
        return this.getLong(this.XV.adr) != -1L;
    }
}

