/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotMetadataRef
extends zzc
implements SnapshotMetadata {
    private final Game aeb;
    private final Player afZ;

    public SnapshotMetadataRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.aeb = new GameRef(dataHolder, n);
        this.afZ = new PlayerRef(dataHolder, n);
    }

    @Override
    public Game getGame() {
        return this.aeb;
    }

    @Override
    public Player getOwner() {
        return this.afZ;
    }

    @Override
    public String getSnapshotId() {
        return this.getString("external_snapshot_id");
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzhp("cover_icon_image_uri");
    }

    @Override
    public String getCoverImageUrl() {
        return this.getString("cover_icon_image_url");
    }

    @Override
    public float getCoverImageAspectRatio() {
        float f = this.getFloat("cover_icon_image_height");
        float f2 = this.getFloat("cover_icon_image_width");
        if (f == 0.0f) {
            return 0.0f;
        }
        return f2 / f;
    }

    @Override
    public String getUniqueName() {
        return this.getString("unique_name");
    }

    @Override
    public String getTitle() {
        return this.getString("title");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("description", charArrayBuffer);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.getLong("last_modified_timestamp");
    }

    @Override
    public long getPlayedTime() {
        return this.getLong("duration");
    }

    @Override
    public boolean hasChangePending() {
        return this.getInteger("pending_change_count") > 0;
    }

    @Override
    public long getProgressValue() {
        return this.getLong("progress_value");
    }

    @Override
    public String getDeviceName() {
        return this.getString("device_name");
    }

    public SnapshotMetadata freeze() {
        return new SnapshotMetadataEntity(this);
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    public boolean equals(Object object) {
        return SnapshotMetadataEntity.zza(this, object);
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        SnapshotMetadataEntity snapshotMetadataEntity = (SnapshotMetadataEntity)((SnapshotMetadata)this.freeze());
        snapshotMetadataEntity.writeToParcel(parcel, n);
    }
}

