/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.iid.zzc;
import java.util.List;

public class GcmNetworkManager {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_RESCHEDULE = 1;
    public static final int RESULT_FAILURE = 2;
    private static GcmNetworkManager zzbgm;
    private Context mContext;
    private final PendingIntent mPendingIntent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcmNetworkManager getInstance(Context context) {
        Class<GcmNetworkManager> clazz = GcmNetworkManager.class;
        synchronized (GcmNetworkManager.class) {
            if (zzbgm == null) {
                zzbgm = new GcmNetworkManager(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbgm;
        }
    }

    private GcmNetworkManager(Context context) {
        this.mContext = context;
        this.mPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent().setPackage("com.google.example.invalidpackage"), (int)0);
    }

    public void schedule(Task task) {
        this.zzez(task.getServiceName());
        Intent intent = this.zzGO();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        bundle.putString("scheduler_action", "SCHEDULE_TASK");
        task.toBundle(bundle);
        intent.putExtras(bundle);
        this.mContext.sendBroadcast(intent);
    }

    public void cancelTask(String string, Class<? extends GcmTaskService> clazz) {
        this.zzb(string, clazz);
    }

    public void zzb(String string, Class<? extends Service> clazz) {
        this.zza(string, new ComponentName(this.mContext, clazz));
    }

    private void zza(String string, ComponentName componentName) {
        GcmNetworkManager.zzey(string);
        this.zzez(componentName.getClassName());
        Intent intent = this.zzGO();
        if (intent == null) {
            return;
        }
        intent.putExtra("scheduler_action", "CANCEL_TASK");
        intent.putExtra("tag", string);
        intent.putExtra("component", (Parcelable)componentName);
        this.mContext.sendBroadcast(intent);
    }

    public void cancelAllTasks(Class<? extends GcmTaskService> clazz) {
        this.zzd(clazz);
    }

    public void zzd(Class<? extends Service> clazz) {
        this.zza(new ComponentName(this.mContext, clazz));
    }

    private void zza(ComponentName componentName) {
        this.zzez(componentName.getClassName());
        Intent intent = this.zzGO();
        if (intent == null) {
            return;
        }
        intent.putExtra("scheduler_action", "CANCEL_ALL");
        intent.putExtra("component", (Parcelable)componentName);
        this.mContext.sendBroadcast(intent);
    }

    private Intent zzGO() {
        String string = zzc.zzbA((Context)this.mContext);
        int n = -1;
        if (string != null) {
            n = GoogleCloudMessaging.zzbv(this.mContext);
        }
        if (string == null || n < GoogleCloudMessaging.zzbgC) {
            int n2 = n;
            Log.e((String)"GcmNetworkManager", (String)new StringBuilder(91).append("Google Play Services is not available, dropping GcmNetworkManager request. code=").append(n2).toString());
            return null;
        }
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_SCHEDULE");
        intent.setPackage(string);
        intent.putExtra("app", (Parcelable)this.mPendingIntent);
        intent.putExtra("source", 4);
        intent.putExtra("source_version", 10400000);
        return intent;
    }

    static void zzey(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Must provide a valid tag.");
        }
        if (100 < string.length()) {
            throw new IllegalArgumentException("Tag is larger than max permissible tag length (100)");
        }
    }

    private void zzez(String string) {
        zzac.zzb((Object)string, (Object)"GcmTaskService must not be null.");
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_TASK_READY");
        intent.setPackage(this.mContext.getPackageName());
        PackageManager packageManager = this.mContext.getPackageManager();
        List list = packageManager.queryIntentServices(intent, 0);
        zzac.zzb((list != null && list.size() != 0 ? 1 : 0) != 0, (Object)"There is no GcmTaskService component registered within this package. Have you extended GcmTaskService correctly?");
        boolean bl = false;
        for (ResolveInfo resolveInfo : list) {
            if (!resolveInfo.serviceInfo.name.equals(string)) continue;
            bl = true;
            break;
        }
        zzac.zzb((boolean)bl, (Object)new StringBuilder(119 + String.valueOf(string).length()).append("The GcmTaskService class you provided ").append(string).append(" does not seem to support receiving com.google.android.gms.gcm.ACTION_TASK_READY.").toString());
    }
}

