/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class OneoffTask
extends Task {
    private final long zzbgM;
    private final long zzbgN;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new Parcelable.Creator<OneoffTask>(){

        public OneoffTask zzgm(Parcel parcel) {
            return new OneoffTask(parcel);
        }

        public OneoffTask[] zzjE(int n) {
            return new OneoffTask[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzjE(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzgm(parcel);
        }
    };

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzbgM = builder.zzbgO;
        this.zzbgN = builder.zzbgP;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zzbgM = parcel.readLong();
        this.zzbgN = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzbgM);
        bundle.putLong("window_end", this.zzbgN);
    }

    public long getWindowStart() {
        return this.zzbgM;
    }

    public long getWindowEnd() {
        return this.zzbgN;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zzbgM);
        parcel.writeLong(this.zzbgN);
    }

    public String toString() {
        String string = String.valueOf(super.toString());
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string).length()).append(string).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    public static class Builder
    extends Task.Builder {
        private long zzbgO = -1L;
        private long zzbgP = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzbgO = l;
            this.zzbgP = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        @Override
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzbgO == -1L || this.zzbgP == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzbgO >= this.zzbgP) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this);
        }
    }
}

