/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzc;

public abstract class Task
implements ReflectedParcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzbgX;
    private final String mTag;
    private final boolean zzbgY;
    private final boolean zzbgZ;
    private final int zzbha;
    private final boolean zzbhb;
    private final boolean zzbhc;
    private final zzc zzbhd;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzbgX = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzbgY = builder.updateCurrent;
        this.zzbgZ = builder.isPersisted;
        this.zzbha = builder.requiredNetworkState;
        this.zzbhb = builder.requiresCharging;
        this.zzbhc = false;
        this.mExtras = builder.extras;
        this.zzbhd = builder.zzbhe != null ? builder.zzbhe : zzc.zzbgS;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzbgX = parcel.readString();
        this.mTag = parcel.readString();
        this.zzbgY = parcel.readInt() == 1;
        this.zzbgZ = parcel.readInt() == 1;
        this.zzbha = 2;
        this.zzbhb = false;
        this.zzbhc = false;
        this.zzbhd = zzc.zzbgS;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzbgY);
        bundle.putBoolean("persisted", this.zzbgZ);
        bundle.putString("service", this.zzbgX);
        bundle.putInt("requiredNetwork", this.zzbha);
        bundle.putBoolean("requiresCharging", this.zzbhb);
        bundle.putBoolean("requiresIdle", false);
        bundle.putBundle("retryStrategy", this.zzbhd.zzJ(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzbgX;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzbgY;
    }

    public boolean isPersisted() {
        return this.zzbgZ;
    }

    public int getRequiredNetwork() {
        return this.zzbha;
    }

    public boolean getRequiresCharging() {
        return this.zzbhb;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zzbgX);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzbgY ? 1 : 0);
        parcel.writeInt(this.zzbgZ ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zza(zzc zzc2) {
        if (zzc2 != null) {
            int n = zzc2.zzGU();
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
            }
            int n2 = zzc2.zzGV();
            int n3 = zzc2.zzGW();
            if (n == 0 && n2 < 0) {
                throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
            }
            if (n == 1 && n2 < 10) {
                throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
            }
            if (n3 < n2) {
                int n4 = zzc2.zzGW();
                throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
            }
        }
    }

    public static void zzK(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                String string = String.valueOf("Extras exceeding maximum size(10240 bytes): ");
                throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
            }
            parcel.recycle();
            for (String string : bundle.keySet()) {
                Object object = bundle.get(string);
                if (Task.zzF(object)) continue;
                if (object instanceof Bundle) {
                    Task.zzK((Bundle)object);
                    continue;
                }
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, Boolean, and nested Bundles with the same restrictions.");
            }
        }
    }

    private static boolean zzF(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzc zzbhe = zzc.zzbgS;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzac.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzey(this.tag);
            Task.zza(this.zzbhe);
            if (this.isPersisted) {
                Task.zzK(this.extras);
            }
        }
    }
}

