/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzf;

public class OneoffTask
extends Task {
    private final long zzbfZ;
    private final long zzbga;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new zzf();

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzbfZ = builder.zzbgb;
        this.zzbga = builder.zzbgc;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zzbfZ = parcel.readLong();
        this.zzbga = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzbfZ);
        bundle.putLong("window_end", this.zzbga);
    }

    public long getWindowStart() {
        return this.zzbfZ;
    }

    public long getWindowEnd() {
        return this.zzbga;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zzbfZ);
        parcel.writeLong(this.zzbga);
    }

    public String toString() {
        String string = String.valueOf(super.toString());
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string).length()).append(string).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    /* synthetic */ OneoffTask(Parcel parcel, zzf zzf2) {
        this(parcel);
    }

    /* synthetic */ OneoffTask(Builder builder, zzf zzf2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzbgb = -1L;
        private long zzbgc = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzbgb = l;
            this.zzbgc = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        @Override
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzbgb == -1L || this.zzbgc == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzbgb >= this.zzbgc) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this, null);
        }
    }
}

