/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.iid.zze;
import java.util.Iterator;
import java.util.List;

public class GcmNetworkManager {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_RESCHEDULE = 1;
    public static final int RESULT_FAILURE = 2;
    private static GcmNetworkManager zzbfv;
    private Context mContext;
    private final PendingIntent mPendingIntent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcmNetworkManager getInstance(Context context) {
        Class<GcmNetworkManager> clazz = GcmNetworkManager.class;
        synchronized (GcmNetworkManager.class) {
            if (zzbfv == null) {
                zzbfv = new GcmNetworkManager(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbfv;
        }
    }

    private GcmNetworkManager(Context context) {
        this.mContext = context;
        this.mPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent().setPackage("com.google.example.invalidpackage"), (int)0);
    }

    public void schedule(Task task) {
        this.zzdo(task.getServiceName());
        Intent intent = this.zzvB();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        bundle.putString("scheduler_action", "SCHEDULE_TASK");
        task.toBundle(bundle);
        intent.putExtras(bundle);
        this.mContext.sendBroadcast(intent);
    }

    public void cancelTask(String string, Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        String string2 = string;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.mContext, clazz2);
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        GcmNetworkManager.zzdn(string3);
        gcmNetworkManager2.zzdo(componentName.getClassName());
        Intent intent = gcmNetworkManager2.zzvB();
        if (intent != null) {
            intent.putExtra("scheduler_action", "CANCEL_TASK");
            intent.putExtra("tag", string3);
            intent.putExtra("component", (Parcelable)componentName);
            gcmNetworkManager2.mContext.sendBroadcast(intent);
        }
    }

    public void cancelAllTasks(Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.mContext, clazz2);
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        gcmNetworkManager.zzdo(componentName.getClassName());
        Intent intent = gcmNetworkManager2.zzvB();
        if (intent != null) {
            intent.putExtra("scheduler_action", "CANCEL_ALL");
            intent.putExtra("component", (Parcelable)componentName);
            gcmNetworkManager2.mContext.sendBroadcast(intent);
        }
    }

    private final Intent zzvB() {
        String string = zze.zzbd((Context)this.mContext);
        int n = -1;
        if (string != null) {
            n = GoogleCloudMessaging.zzaZ(this.mContext);
        }
        if (string == null || n < GoogleCloudMessaging.zzbfL) {
            int n2 = n;
            Log.e((String)"GcmNetworkManager", (String)new StringBuilder(91).append("Google Play Services is not available, dropping GcmNetworkManager request. code=").append(n2).toString());
            return null;
        }
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_SCHEDULE");
        intent.setPackage(string);
        intent.putExtra("app", (Parcelable)this.mPendingIntent);
        intent.putExtra("source", 4);
        intent.putExtra("source_version", 11011000);
        return intent;
    }

    static void zzdn(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Must provide a valid tag.");
        }
        if (100 < string.length()) {
            throw new IllegalArgumentException("Tag is larger than max permissible tag length (100)");
        }
    }

    private final void zzdo(String string) {
        zzbo.zzb((Object)string, (Object)"GcmTaskService must not be null.");
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_TASK_READY");
        intent.setPackage(this.mContext.getPackageName());
        List list = this.mContext.getPackageManager().queryIntentServices(intent, 0);
        zzbo.zzb((list != null && list.size() != 0 ? 1 : 0) != 0, (Object)"There is no GcmTaskService component registered within this package. Have you extended GcmTaskService correctly?");
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!((ResolveInfo)iterator.next()).serviceInfo.name.equals(string)) continue;
            bl = true;
            break;
        }
        zzbo.zzb((boolean)bl, (Object)new StringBuilder(119 + String.valueOf(string).length()).append("The GcmTaskService class you provided ").append(string).append(" does not seem to support receiving com.google.android.gms.gcm.ACTION_TASK_READY.").toString());
    }
}

