/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzd;
import com.google.android.gms.gcm.zze;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Object lock = new Object();
    private final Set<String> zzbfE = new HashSet<String>();
    private int zzbfF;
    private ExecutorService zzqF;
    private Messenger zzbfG;
    private ComponentName componentName;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        GcmTaskService gcmTaskService = this;
        this.zzqF = Executors.newFixedThreadPool(2, new com.google.android.gms.gcm.zzb(gcmTaskService));
        this.zzbfG = new Messenger((Handler)new zza(this, Looper.getMainLooper()));
        this.componentName = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
    }

    @CallSuper
    public void onDestroy() {
        super.onDestroy();
        List<Runnable> list = this.zzqF.shutdownNow();
        if (!list.isEmpty()) {
            int n = list.size();
            Log.e((String)"GcmTaskService", (String)new StringBuilder(79).append("Shutting down, but not all tasks are finished executing. Remaining: ").append(n).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CallSuper
    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent == null) {
            this.zzbf(n2);
            return 2;
        }
        try {
            intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
            String string = intent.getAction();
            if (SERVICE_ACTION_EXECUTE_TASK.equals(string)) {
                String string2 = intent.getStringExtra("tag");
                Parcelable parcelable = intent.getParcelableExtra("callback");
                Bundle bundle = intent.getBundleExtra("extras");
                ArrayList arrayList = intent.getParcelableArrayListExtra("triggered_uris");
                if (!(parcelable instanceof PendingCallback)) {
                    String string3 = String.valueOf(this.getPackageName());
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(47 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).append(": Could not process request, invalid callback.").toString());
                    return 2;
                }
                Object object = this.lock;
                synchronized (object) {
                    if (!this.zzbfE.add(string2)) {
                        String string4 = String.valueOf(this.getPackageName());
                        Log.w((String)"GcmTaskService", (String)new StringBuilder(44 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" ").append(string2).append(": Task already running, won't start another").toString());
                        return 2;
                    }
                }
                object = ((PendingCallback)parcelable).zzaHj;
                zzb zzb2 = new zzb(this, string2, (IBinder)object, bundle, (List<Uri>)arrayList);
                this.zza(zzb2);
                return 2;
            }
            if (SERVICE_ACTION_INITIALIZE.equals(string)) {
                this.onInitializeTasks();
                return 2;
            }
            Log.e((String)"GcmTaskService", (String)new StringBuilder(37 + String.valueOf(string).length()).append("Unknown action received ").append(string).append(", terminating").toString());
            return 2;
        }
        finally {
            this.zzbf(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbf(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.zzbfF = n;
            if (this.zzbfE.isEmpty()) {
                this.stopSelf(this.zzbfF);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzdp(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.zzbfE.remove(string);
            if (this.zzbfE.isEmpty()) {
                this.stopSelf(this.zzbfF);
            }
            return;
        }
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (intent == null || !zzq.zzse() || !SERVICE_ACTION_EXECUTE_TASK.equals(intent.getAction())) {
            return null;
        }
        return this.zzbfG.getBinder();
    }

    private final void zza(zzb zzb2) {
        try {
            this.zzqF.execute(zzb2);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Log.e((String)"GcmTaskService", (String)"Executor is shutdown. onDestroy was called but main looper had an unprocessed start task message. The task will be retried with backoff delay.", (Throwable)rejectedExecutionException);
            zzb2.zzbg(1);
            return;
        }
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    final class zzb
    implements Runnable {
        private final String mTag;
        private final Bundle mExtras;
        private final List<Uri> zzbfJ;
        @Nullable
        private final zzd zzbfK;
        @Nullable
        private final Messenger mMessenger;
        private /* synthetic */ GcmTaskService zzbfI;

        zzb(GcmTaskService gcmTaskService, String string, IBinder iBinder, Bundle bundle, List<Uri> list) {
            IInterface iInterface;
            this.zzbfI = gcmTaskService;
            this.mTag = string;
            IBinder iBinder2 = iBinder;
            this.zzbfK = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.gcm.INetworkTaskCallback")) instanceof zzd ? (zzd)iInterface : new zze(iBinder2));
            this.mExtras = bundle;
            this.zzbfJ = list;
            this.mMessenger = null;
        }

        zzb(GcmTaskService gcmTaskService, String string, Messenger messenger, Bundle bundle, List<Uri> list) {
            this.zzbfI = gcmTaskService;
            this.mTag = string;
            this.mMessenger = messenger;
            this.mExtras = bundle;
            this.zzbfJ = list;
            this.zzbfK = null;
        }

        @Override
        public final void run() {
            TaskParams taskParams = new TaskParams(this.mTag, this.mExtras, this.zzbfJ);
            int n = this.zzbfI.onRunTask(taskParams);
            this.zzbg(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzbg(int n) {
            Object object = this.zzbfI.lock;
            synchronized (object) {
                try {
                    if (this.zzvC()) {
                        int n2 = n;
                        zzb zzb2 = this;
                        Message message = Message.obtain();
                        Message.obtain().what = 3;
                        message.arg1 = n2;
                        Bundle bundle = new Bundle();
                        bundle.putParcelable("component", (Parcelable)zzb2.zzbfI.componentName);
                        bundle.putString("tag", zzb2.mTag);
                        message.setData(bundle);
                        this.mMessenger.send(message);
                    } else {
                        this.zzbfK.zzbh(n);
                    }
                }
                catch (RemoteException remoteException) {
                    String string = String.valueOf(this.mTag);
                    Log.e((String)"GcmTaskService", (String)(string.length() != 0 ? "Error reporting result of operation to scheduler for ".concat(string) : new String("Error reporting result of operation to scheduler for ")));
                }
                finally {
                    if (!this.zzvC()) {
                        this.zzbfI.zzdp(this.mTag);
                    }
                }
                return;
            }
        }

        private final boolean zzvC() {
            return this.mMessenger != null;
        }
    }

    @TargetApi(value=21)
    final class zza
    extends Handler {
        private /* synthetic */ GcmTaskService zzbfI;

        zza(GcmTaskService gcmTaskService, Looper looper) {
            this.zzbfI = gcmTaskService;
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (!zzw.zzb((Context)this.zzbfI, (int)message.sendingUid, (String)"com.google.android.gms")) {
                Log.e((String)"GcmTaskService", (String)"unable to verify presence of Google Play Services");
                return;
            }
            switch (message.what) {
                case 1: {
                    Messenger messenger;
                    Message message2 = message;
                    zza zza2 = this;
                    Bundle bundle = message2.getData();
                    if (bundle != null && (messenger = message2.replyTo) != null) {
                        String string = bundle.getString("tag");
                        ArrayList arrayList = bundle.getParcelableArrayList("triggered_uris");
                        zza2.zzbfI.zza(new zzb(zza2.zzbfI, string, messenger, bundle.getBundle("extras"), (List<Uri>)arrayList));
                    }
                    return;
                }
                case 2: {
                    Message message3 = message;
                    if (Log.isLoggable((String)"GcmTaskService", (int)3)) {
                        String string = String.valueOf(message3);
                        Log.d((String)"GcmTaskService", (String)new StringBuilder(45 + String.valueOf(string).length()).append("ignoring unimplemented stop message for now: ").append(string).toString());
                    }
                    return;
                }
                case 4: {
                    this.zzbfI.onInitializeTasks();
                    return;
                }
            }
            String string = String.valueOf(message);
            Log.e((String)"GcmTaskService", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Unrecognized message received: ").append(string).toString());
        }
    }
}

