/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzi;

public class Task
implements ReflectedParcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzbgg;
    private final String mTag;
    private final boolean zzbgh;
    private final boolean zzbgi;
    private final int zzbgj;
    private final boolean zzbgk;
    private final boolean zzbgl;
    private final zzi zzbgm;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzbgg = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzbgh = builder.updateCurrent;
        this.zzbgi = builder.isPersisted;
        this.zzbgj = builder.requiredNetworkState;
        this.zzbgk = builder.requiresCharging;
        this.zzbgl = false;
        this.mExtras = builder.extras;
        this.zzbgm = builder.zzbgn != null ? builder.zzbgn : zzi.zzbgb;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzbgg = parcel.readString();
        this.mTag = parcel.readString();
        this.zzbgh = parcel.readInt() == 1;
        this.zzbgi = parcel.readInt() == 1;
        this.zzbgj = 2;
        this.zzbgk = false;
        this.zzbgl = false;
        this.zzbgm = zzi.zzbgb;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzbgh);
        bundle.putBoolean("persisted", this.zzbgi);
        bundle.putString("service", this.zzbgg);
        bundle.putInt("requiredNetwork", this.zzbgj);
        bundle.putBoolean("requiresCharging", this.zzbgk);
        bundle.putBoolean("requiresIdle", false);
        bundle.putBundle("retryStrategy", this.zzbgm.zzx(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzbgg;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzbgh;
    }

    public boolean isPersisted() {
        return this.zzbgi;
    }

    public int getRequiredNetwork() {
        return this.zzbgj;
    }

    public boolean getRequiresCharging() {
        return this.zzbgk;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zzbgg);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzbgh ? 1 : 0);
        parcel.writeInt(this.zzbgi ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zzy(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                String string = String.valueOf("Extras exceeding maximum size(10240 bytes): ");
                throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
            }
            parcel.recycle();
            for (String string : bundle.keySet()) {
                Object object;
                Object object2 = object = bundle.get(string);
                if (object instanceof Integer || object2 instanceof Long || object2 instanceof Double || object2 instanceof String || object2 instanceof Boolean) continue;
                if (object instanceof Bundle) {
                    Task.zzy((Bundle)object);
                    continue;
                }
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, Boolean, and nested Bundles with the same restrictions.");
            }
        }
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzi zzbgn = zzi.zzbgb;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzbo.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzdn(this.tag);
            zzi zzi2 = this.zzbgn;
            if (zzi2 != null) {
                int n = zzi2.zzvE();
                if (n != 1 && n != 0) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
                }
                int n2 = zzi2.zzvF();
                int n3 = zzi2.zzvG();
                if (n == 0 && n2 < 0) {
                    throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
                }
                if (n == 1 && n2 < 10) {
                    throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
                }
                if (n3 < n2) {
                    int n4 = zzi2.zzvG();
                    throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
                }
            }
            if (this.isPersisted) {
                Task.zzy(this.extras);
            }
        }
    }
}

