/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.gcm.GcmListenerService;
import java.util.Iterator;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

final class zza {
    static zza zzbfw;
    private final Context mContext;

    static synchronized zza zzaX(Context context) {
        if (zzbfw == null) {
            zzbfw = new zza(context);
        }
        return zzbfw;
    }

    static boolean zzaY(Context context) {
        if (((KeyguardManager)context.getSystemService("keyguard")).inKeyguardRestrictedInputMode()) {
            return false;
        }
        int n = Process.myPid();
        List list = ((ActivityManager)context.getSystemService("activity")).getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    static void zzu(Bundle bundle) {
        String string;
        Bundle bundle2 = new Bundle();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = bundle.getString(string);
            if (string.startsWith("gcm.notification.")) {
                string = string.replace("gcm.notification.", "gcm.n.");
            }
            if (!string.startsWith("gcm.n.")) continue;
            if (!"gcm.n.e".equals(string)) {
                bundle2.putString(string.substring(6), string2);
            }
            iterator.remove();
        }
        string = bundle2.getString("sound2");
        if (string != null) {
            bundle2.remove("sound2");
            bundle2.putString("sound", string);
        }
        if (!bundle2.isEmpty()) {
            bundle.putBundle("notification", bundle2);
        }
    }

    static String zze(Bundle bundle, String string) {
        String string2 = bundle.getString(string);
        if (string2 == null) {
            string2 = bundle.getString(string.replace("gcm.n.", "gcm.notification."));
        }
        return string2;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final boolean zzv(Bundle var1_1) {
        var4_2 /* !! */  = var1_1;
        var3_3 = this;
        var5_4 = var3_3.zzf(var4_2 /* !! */ , "gcm.n.title");
        var6_5 = var3_3.zzf(var4_2 /* !! */ , "gcm.n.body");
        var13_6 = zza.zze(var4_2 /* !! */ , "gcm.n.icon");
        var12_7 = var3_3;
        if (TextUtils.isEmpty((CharSequence)var13_6)) ** GOTO lbl19
        var14_8 = var12_7.mContext.getResources();
        var15_10 = var14_8.getIdentifier(var13_6, "drawable", var12_7.mContext.getPackageName());
        if (var15_10 != 0) {
            v0 = var15_10;
        } else {
            var15_10 = var14_8.getIdentifier(var13_6, "mipmap", var12_7.mContext.getPackageName());
            if (var15_10 != 0) {
                v0 = var15_10;
            } else {
                Log.w((String)"GcmNotification", (String)new StringBuilder(57 + String.valueOf(var13_6).length()).append("Icon resource ").append(var13_6).append(" not found. Notification will use app icon.").toString());
lbl19:
                // 2 sources

                if ((var14_9 = var12_7.mContext.getApplicationInfo().icon) == 0) {
                    var14_9 = 17301651;
                }
                v0 = var14_9;
            }
        }
        var7_11 = v0;
        var8_13 = zza.zze(var4_2 /* !! */ , "gcm.n.color");
        var13_6 = zza.zze(var4_2 /* !! */ , "gcm.n.sound2");
        var12_7 = var3_3;
        if (TextUtils.isEmpty((CharSequence)var13_6)) {
            v1 = null;
        } else if (!"default".equals(var13_6) && var12_7.mContext.getResources().getIdentifier(var13_6, "raw", var12_7.mContext.getPackageName()) != 0) {
            var16_14 = String.valueOf("android.resource://");
            var17_15 = String.valueOf(var12_7.mContext.getPackageName());
            v1 = Uri.parse((String)new StringBuilder(5 + String.valueOf(var16_14).length() + String.valueOf(var17_15).length() + String.valueOf(var13_6).length()).append(var16_14).append(var17_15).append("/raw/").append(var13_6).toString());
        } else {
            v1 = RingtoneManager.getDefaultUri((int)2);
        }
        var9_16 = v1;
        var10_17 = var3_3.zzw(var4_2 /* !! */ );
        var11_18 = new NotificationCompat.Builder(var3_3.mContext).setAutoCancel(true).setSmallIcon(var7_11);
        if (!TextUtils.isEmpty((CharSequence)var5_4)) {
            var11_18.setContentTitle((CharSequence)var5_4);
        } else {
            var11_18.setContentTitle(var3_3.mContext.getApplicationInfo().loadLabel(var3_3.mContext.getPackageManager()));
        }
        if (!TextUtils.isEmpty((CharSequence)var6_5)) {
            var11_18.setContentText((CharSequence)var6_5);
        }
        if (!TextUtils.isEmpty((CharSequence)var8_13)) {
            var11_18.setColor(Color.parseColor((String)var8_13));
        }
        if (var9_16 != null) {
            var11_18.setSound(var9_16);
        }
        if (var10_17 != null) {
            var11_18.setContentIntent(var10_17);
        }
        var2_19 = var11_18.build();
        var5_4 = var2_19;
        var4_2 /* !! */  = zza.zze(var1_1, "gcm.n.tag");
        var3_3 = this;
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        var6_5 = (NotificationManager)var3_3.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)var4_2 /* !! */ )) {
            var7_12 = SystemClock.uptimeMillis();
            var4_2 /* !! */  = new StringBuilder(37).append("GCM-Notification:").append(var7_12).toString();
        }
        var6_5.notify((String)var4_2 /* !! */ , 0, (Notification)var5_4);
        return true;
    }

    private final String zzf(Bundle bundle, String string) {
        String string2 = zza.zze(bundle, string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        String string3 = String.valueOf(string);
        String string4 = String.valueOf("_loc_key");
        String string5 = zza.zze(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
        if (TextUtils.isEmpty((CharSequence)string5)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string5, "string", this.mContext.getPackageName());
        if (n == 0) {
            String string6 = String.valueOf(string);
            String string7 = String.valueOf("_loc_key");
            String string8 = string7.length() != 0 ? string6.concat(string7) : new String(string6);
            String string9 = String.valueOf(string8.substring(6));
            Log.w((String)"GcmNotification", (String)new StringBuilder(49 + String.valueOf(string9).length() + String.valueOf(string5).length()).append(string9).append(" resource not found: ").append(string5).append(" Default value will be used.").toString());
            return null;
        }
        String string10 = String.valueOf(string);
        String string11 = String.valueOf("_loc_args");
        String string12 = zza.zze(bundle, string11.length() != 0 ? string10.concat(string11) : new String(string10));
        if (TextUtils.isEmpty((CharSequence)string12)) {
            return resources.getString(n);
        }
        try {
            JSONArray jSONArray = new JSONArray(string12);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return resources.getString(n, objectArray);
        }
        catch (JSONException jSONException) {
            String string13 = String.valueOf(string);
            String string14 = String.valueOf("_loc_args");
            String string15 = string14.length() != 0 ? string13.concat(string14) : new String(string13);
            String string16 = String.valueOf(string15.substring(6));
            Log.w((String)"GcmNotification", (String)new StringBuilder(41 + String.valueOf(string16).length() + String.valueOf(string12).length()).append("Malformed ").append(string16).append(": ").append(string12).append("  Default value will be used.").toString());
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            Log.w((String)"GcmNotification", (String)new StringBuilder(58 + String.valueOf(string5).length() + String.valueOf(string12).length()).append("Missing format argument for ").append(string5).append(": ").append(string12).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
        }
        return null;
    }

    private final PendingIntent zzw(Bundle bundle) {
        Intent intent;
        String string = zza.zze(bundle, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            intent = new Intent(string);
            intent.setPackage(this.mContext.getPackageName());
            intent.setFlags(0x10000000);
        } else {
            intent = this.mContext.getPackageManager().getLaunchIntentForPackage(this.mContext.getPackageName());
            if (intent == null) {
                Log.w((String)"GcmNotification", (String)"No activity found to launch app");
                return null;
            }
        }
        bundle = new Bundle(bundle);
        GcmListenerService.zzt(bundle);
        intent.putExtras(bundle);
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("gcm.n.") && !string2.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string2);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)((int)SystemClock.uptimeMillis()), (Intent)intent, (int)0x40000000);
    }
}

