/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.os.UserManager;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.iid.zze;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GcmNetworkManager {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_RESCHEDULE = 1;
    public static final int RESULT_FAILURE = 2;
    private static GcmNetworkManager zzhqe;
    private Context mContext;
    private final PendingIntent mPendingIntent;
    private Boolean zzhqf;
    private final Map<String, Map<String, Boolean>> zzhqg = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcmNetworkManager getInstance(Context context) {
        Class<GcmNetworkManager> clazz = GcmNetworkManager.class;
        synchronized (GcmNetworkManager.class) {
            if (zzhqe == null) {
                zzhqe = new GcmNetworkManager(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzhqe;
        }
    }

    private GcmNetworkManager(Context context) {
        this.mContext = context;
        this.mPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent().setPackage("com.google.example.invalidpackage"), (int)0);
    }

    public synchronized void schedule(Task task) {
        if (!this.zzho(task.getServiceName())) {
            return;
        }
        Intent intent = this.zzase();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        bundle.putString("scheduler_action", "SCHEDULE_TASK");
        task.toBundle(bundle);
        intent.putExtras(bundle);
        this.mContext.sendBroadcast(intent);
        Map<String, Boolean> map = this.zzhqg.get(task.getServiceName());
        if (map != null && map.containsKey(task.getTag())) {
            map.put(task.getTag(), true);
        }
    }

    public void cancelTask(String string2, Class<? extends GcmTaskService> clazz) {
        Intent intent;
        Class<? extends GcmTaskService> clazz2 = clazz;
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.mContext, clazz2);
        String string4 = string3;
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        GcmNetworkManager.zzhn(string4);
        if (gcmNetworkManager2.zzho(componentName.getClassName()) && (intent = gcmNetworkManager2.zzase()) != null) {
            intent.putExtra("scheduler_action", "CANCEL_TASK");
            intent.putExtra("tag", string4);
            intent.putExtra("component", (Parcelable)componentName);
            gcmNetworkManager2.mContext.sendBroadcast(intent);
        }
    }

    public void cancelAllTasks(Class<? extends GcmTaskService> clazz) {
        Intent intent;
        Class<? extends GcmTaskService> clazz2 = clazz;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.mContext, clazz2);
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        if (gcmNetworkManager.zzho(componentName.getClassName()) && (intent = gcmNetworkManager2.zzase()) != null) {
            intent.putExtra("scheduler_action", "CANCEL_ALL");
            intent.putExtra("component", (Parcelable)componentName);
            gcmNetworkManager2.mContext.sendBroadcast(intent);
        }
    }

    private final Intent zzase() {
        String string2 = zze.zzdg((Context)this.mContext);
        int n = -1;
        if (string2 != null) {
            n = GoogleCloudMessaging.zzdc(this.mContext);
        }
        if (string2 == null || n < GoogleCloudMessaging.zzhra) {
            int n2 = n;
            Log.e((String)"GcmNetworkManager", (String)new StringBuilder(91).append("Google Play Services is not available, dropping GcmNetworkManager request. code=").append(n2).toString());
            return null;
        }
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_SCHEDULE");
        intent.setPackage(string2);
        intent.putExtra("app", (Parcelable)this.mPendingIntent);
        intent.putExtra("source", 4);
        intent.putExtra("source_version", 11200000);
        return intent;
    }

    static void zzhn(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Must provide a valid tag.");
        }
        if (100 < string2.length()) {
            throw new IllegalArgumentException("Tag is larger than max permissible tag length (100)");
        }
    }

    private final boolean zzho(String string2) {
        List list;
        List list2;
        zzbp.zzb((Object)string2, (Object)"GcmTaskService must not be null.");
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager = this;
        PackageManager packageManager = gcmNetworkManager.mContext.getPackageManager();
        if (packageManager == null) {
            list2 = null;
        } else {
            Object object;
            UserManager userManager;
            boolean bl;
            GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
            boolean bl2 = Build.VERSION.SDK_INT < 17;
            boolean bl3 = bl = Build.VERSION.SDK_INT < 24;
            if (!(bl2 || bl && !gcmNetworkManager2.zzasf() ? true : (userManager = (UserManager)gcmNetworkManager2.mContext.getSystemService("user")) == null || userManager.isUserRunning(Process.myUserHandle()))) {
                object = string3 == null ? "unknown service" : string3;
                Log.w((String)"GcmNetworkManager", (String)new StringBuilder(51 + String.valueOf(object).length()).append("Dropping request for ").append((String)object).append(" because user is shutting down").toString());
                list2 = null;
            } else {
                String string4 = string3;
                gcmNetworkManager2 = gcmNetworkManager;
                object = GcmNetworkManager.zza(packageManager, string4 != null ? new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setClassName(gcmNetworkManager2.mContext, string4) : new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setPackage(gcmNetworkManager2.mContext.getPackageName()), 0);
                list2 = list = object == null ? Collections.emptyList() : object;
            }
        }
        if (list2 == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!((ResolveInfo)iterator.next()).serviceInfo.name.equals(string2)) continue;
            return true;
        }
        throw new IllegalArgumentException(new StringBuilder(118 + String.valueOf(string2).length()).append("The GcmTaskService class you provided ").append(string2).append(" does not seem to support receiving com.google.android.gms.gcm.ACTION_TASK_READY").toString());
    }

    private static List<ResolveInfo> zza(PackageManager packageManager, Intent intent, int n) {
        List list = null;
        for (int i = 0; i < 2; ++i) {
            List list2 = list = packageManager.queryIntentServices(intent, 0);
            if (list == null ? true : list2.isEmpty()) continue;
            if (i <= 0) break;
            Log.i((String)"GcmNetworkManager", (String)new StringBuilder(46).append("validation query succeeded on try #2").toString());
            break;
        }
        return list;
    }

    private final synchronized boolean zzasf() {
        if (this.zzhqf == null) {
            this.zzhqf = this.mContext.checkPermission("android.permission.INTERACT_ACROSS_USERS", Process.myPid(), Process.myUid()) == 0;
        }
        return this.zzhqf;
    }

    final synchronized boolean zzad(String string2, String string3) {
        ArrayMap arrayMap = this.zzhqg.get(string3);
        if (arrayMap == null) {
            arrayMap = new ArrayMap();
            this.zzhqg.put(string3, (Map<String, Boolean>)arrayMap);
        }
        return arrayMap.put(string2, false) == null;
    }

    final synchronized void zzae(String string2, String string3) {
        Map<String, Boolean> map = this.zzhqg.get(string3);
        if (map != null && map.remove(string2) != null && map.isEmpty()) {
            this.zzhqg.remove(string3);
        }
    }

    final synchronized boolean zzaf(String string2, String string3) {
        Map<String, Boolean> map = this.zzhqg.get(string3);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    final synchronized boolean zzhp(String string2) {
        return this.zzhqg.containsKey(string2);
    }
}

