/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.gcm.zza;
import com.google.android.gms.gcm.zzc;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.zze;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    public static int zzhra = 5000000;
    private static int zzhrb = 6500000;
    private static int zzhrc = 7000000;
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    @Deprecated
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    @Deprecated
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_EVENT = "send_event";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    public static final String INSTANCE_ID_SCOPE = "GCM";
    private static GoogleCloudMessaging zzhrd;
    private Context zzaie;
    private PendingIntent zzhre;
    private Map<String, Handler> zzhrf = Collections.synchronizedMap(new ArrayMap());
    private static final AtomicInteger zzhrg;
    private final BlockingQueue<Intent> zzhrh = new LinkedBlockingQueue<Intent>();
    private Messenger zzhri = new Messenger((Handler)new zzc(this, Looper.getMainLooper()));

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzhrd == null) {
            zzhrd = new GoogleCloudMessaging();
            new GoogleCloudMessaging().zzaie = context.getApplicationContext();
        }
        return zzhrd;
    }

    public GoogleCloudMessaging() {
    }

    public void close() {
        zzhrd = null;
        zza.zzhqh = null;
        this.zzasi();
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string2, String string3, Bundle bundle) throws IOException {
        this.send(string2, string3, -1L, bundle);
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string2, String string3, long l, Bundle bundle) throws IOException {
        Bundle bundle2 = bundle;
        String string4 = string3;
        String string5 = string2;
        GoogleCloudMessaging googleCloudMessaging = this;
        if (string5 == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        String string6 = zze.zzdg((Context)googleCloudMessaging.zzaie);
        if (string6 == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle2 != null) {
            intent.putExtras(bundle2);
        }
        googleCloudMessaging.zzf(intent);
        intent.setPackage(string6);
        intent.putExtra("google.to", string5);
        intent.putExtra("google.message_id", string4);
        intent.putExtra("google.ttl", Long.toString(l));
        intent.putExtra("google.delay", Integer.toString(-1));
        String string7 = string5;
        GoogleCloudMessaging googleCloudMessaging2 = googleCloudMessaging;
        int n = string7.indexOf(64);
        String string8 = n > 0 ? string7.substring(0, n) : string7;
        InstanceID.getInstance((Context)googleCloudMessaging2.zzaie);
        intent.putExtra("google.from", InstanceID.zzasr().zze("", string8, INSTANCE_ID_SCOPE));
        if (string6.contains(".gsf")) {
            Bundle bundle3 = new Bundle();
            for (String string9 : bundle2.keySet()) {
                Object object = bundle2.get(string9);
                if (!(object instanceof String)) continue;
                String string10 = String.valueOf(string9);
                bundle3.putString(string10.length() != 0 ? "gcm.".concat(string10) : new String("gcm."), (String)object);
            }
            bundle3.putString("google.to", string5);
            bundle3.putString("google.message_id", string4);
            InstanceID.getInstance((Context)googleCloudMessaging.zzaie).zzb(INSTANCE_ID_SCOPE, "upstream", bundle3);
            return;
        }
        googleCloudMessaging.zzaie.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private final boolean zze(Intent intent) {
        Handler handler;
        String string2 = intent.getStringExtra("In-Reply-To");
        if (string2 == null && intent.hasExtra("error")) {
            string2 = intent.getStringExtra("google.message_id");
        }
        if (string2 != null && (handler = this.zzhrf.remove(string2)) != null) {
            Message message = Message.obtain();
            Message.obtain().obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        InstanceID.getInstance((Context)this.zzaie).deleteInstanceID();
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized String register(String ... stringArray) throws IOException {
        return this.zza(zze.zzdf((Context)this.zzaie), stringArray);
    }

    @Deprecated
    private final synchronized String zza(boolean bl, String ... stringArray) throws IOException {
        String string2 = zze.zzdg((Context)this.zzaie);
        if (string2 == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string3 = GoogleCloudMessaging.zzc(stringArray);
        Bundle bundle = new Bundle();
        if (string2.contains(".gsf")) {
            bundle.putString("legacy.sender", string3);
            return InstanceID.getInstance((Context)this.zzaie).getToken(string3, INSTANCE_ID_SCOPE, bundle);
        }
        bundle.putString("sender", string3);
        String string4 = "registration_id";
        Intent intent = this.zza(bundle, bl);
        if (intent == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string5 = intent.getStringExtra(string4);
        if (string5 != null) {
            return string5;
        }
        String string6 = intent.getStringExtra("error");
        if (string6 != null) {
            throw new IOException(string6);
        }
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    @Deprecated
    private final Intent zza(Bundle bundle, boolean bl) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        if (GoogleCloudMessaging.zzdc(this.zzaie) < 0) {
            throw new IOException("Google Play Services missing");
        }
        Intent intent = new Intent(bl ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zze.zzdg((Context)this.zzaie));
        this.zzf(intent);
        String string2 = String.valueOf("google.rpc");
        String string3 = String.valueOf(String.valueOf(zzhrg.getAndIncrement()));
        String string4 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        intent.putExtra("google.message_id", string4);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzhri);
        if (bl) {
            this.zzaie.sendBroadcast(intent);
        } else {
            this.zzaie.startService(intent);
        }
        try {
            return this.zzhrh.poll(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private static String zzc(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string2)) {
            return null;
        }
        String string3 = intent.getStringExtra("message_type");
        if (string3 != null) {
            return string3;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    private final synchronized void zzf(Intent intent) {
        if (this.zzhre == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzhre = PendingIntent.getBroadcast((Context)this.zzaie, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzhre);
    }

    private final synchronized void zzasi() {
        if (this.zzhre != null) {
            this.zzhre.cancel();
            this.zzhre = null;
        }
    }

    public static int zzdc(Context context) {
        String string2 = zze.zzdg((Context)context);
        if (string2 != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string2, 0);
                if (packageInfo != null) {
                    return packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return -1;
    }

    static /* synthetic */ BlockingQueue zza(GoogleCloudMessaging googleCloudMessaging) {
        return googleCloudMessaging.zzhrh;
    }

    static /* synthetic */ boolean zza(GoogleCloudMessaging googleCloudMessaging, Intent intent) {
        return googleCloudMessaging.zze(intent);
    }

    static /* synthetic */ Context zzb(GoogleCloudMessaging googleCloudMessaging) {
        return googleCloudMessaging.zzaie;
    }

    static {
        zzhrg = new AtomicInteger(1);
    }
}

