/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzi;

public class Task
implements ReflectedParcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzhrv;
    private final String mTag;
    private final boolean zzhrw;
    private final boolean zzhrx;
    private final int zzhry;
    private final boolean zzhrz;
    private final boolean zzhsa;
    private final zzi zzhsb;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzhrv = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzhrw = builder.updateCurrent;
        this.zzhrx = builder.isPersisted;
        this.zzhry = builder.requiredNetworkState;
        this.zzhrz = builder.requiresCharging;
        this.zzhsa = false;
        this.mExtras = builder.extras;
        this.zzhsb = builder.zzhsc != null ? builder.zzhsc : zzi.zzhrq;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzhrv = parcel.readString();
        this.mTag = parcel.readString();
        this.zzhrw = parcel.readInt() == 1;
        this.zzhrx = parcel.readInt() == 1;
        this.zzhry = 2;
        this.zzhrz = false;
        this.zzhsa = false;
        this.zzhsb = zzi.zzhrq;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzhrw);
        bundle.putBoolean("persisted", this.zzhrx);
        bundle.putString("service", this.zzhrv);
        bundle.putInt("requiredNetwork", this.zzhry);
        bundle.putBoolean("requiresCharging", this.zzhrz);
        bundle.putBoolean("requiresIdle", false);
        bundle.putBundle("retryStrategy", this.zzhsb.zzt(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzhrv;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzhrw;
    }

    public boolean isPersisted() {
        return this.zzhrx;
    }

    public int getRequiredNetwork() {
        return this.zzhry;
    }

    public boolean getRequiresCharging() {
        return this.zzhrz;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zzhrv);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzhrw ? 1 : 0);
        parcel.writeInt(this.zzhrx ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zzu(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                String string2 = "Extras exceeding maximum size(10240 bytes): ";
                throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n).toString());
            }
            parcel.recycle();
            for (String string3 : bundle.keySet()) {
                Object object;
                Object object2 = object = bundle.get(string3);
                if (object instanceof Integer || object2 instanceof Long || object2 instanceof Double || object2 instanceof String || object2 instanceof Boolean) continue;
                if (object instanceof Bundle) {
                    Task.zzu((Bundle)object);
                    continue;
                }
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, Boolean, and nested Bundles with the same restrictions.");
            }
        }
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzi zzhsc = zzi.zzhrq;
        protected Bundle extras;

        public Builder() {
        }

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzbp.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzhn(this.tag);
            zzi zzi2 = this.zzhsc;
            if (zzi2 != null) {
                int n = zzi2.zzasj();
                if (n != 1 && n != 0) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
                }
                int n2 = zzi2.zzask();
                int n3 = zzi2.zzasl();
                if (n == 0 && n2 < 0) {
                    throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
                }
                if (n == 1 && n2 < 10) {
                    throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
                }
                if (n3 < n2) {
                    int n4 = zzi2.zzasl();
                    throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
                }
            }
            if (this.isPersisted) {
                Task.zzu(this.extras);
            }
        }
    }
}

