/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.gcm.GcmListenerService;
import java.util.Iterator;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;

final class zza {
    static zza zzibw;
    private final Context mContext;
    private String zzibx;
    private final AtomicInteger zziby = new AtomicInteger((int)SystemClock.elapsedRealtime());

    static synchronized zza zzdj(Context context) {
        if (zzibw == null) {
            zzibw = new zza(context);
        }
        return zzibw;
    }

    static boolean zzdk(Context context) {
        if (((KeyguardManager)context.getSystemService("keyguard")).inKeyguardRestrictedInputMode()) {
            return false;
        }
        int n = Process.myPid();
        List list = ((ActivityManager)context.getSystemService("activity")).getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    static void zzr(Bundle bundle) {
        String string2;
        Bundle bundle2 = new Bundle();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            String string3 = bundle.getString(string2);
            if (string2.startsWith("gcm.notification.")) {
                string2 = string2.replace("gcm.notification.", "gcm.n.");
            }
            if (!string2.startsWith("gcm.n.")) continue;
            if (!"gcm.n.e".equals(string2)) {
                bundle2.putString(string2.substring(6), string3);
            }
            iterator.remove();
        }
        string2 = bundle2.getString("sound2");
        if (string2 != null) {
            bundle2.remove("sound2");
            bundle2.putString("sound", string2);
        }
        if (!bundle2.isEmpty()) {
            bundle.putBundle("notification", bundle2);
        }
    }

    static String zze(Bundle bundle, String string2) {
        String string3 = bundle.getString(string2);
        if (string3 == null) {
            string3 = bundle.getString(string2.replace("gcm.n.", "gcm.notification."));
        }
        return string3;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final boolean zzs(Bundle var1_1) {
        block33: {
            block24: {
                block26: {
                    block32: {
                        block30: {
                            block31: {
                                block29: {
                                    block27: {
                                        block28: {
                                            block25: {
                                                var3_3 = this;
                                                var4_2 /* !! */  = var1_1;
                                                var5_4 /* !! */  = var3_3.zzf(var4_2 /* !! */ , "gcm.n.title");
                                                if (TextUtils.isEmpty((CharSequence)var5_4 /* !! */ )) {
                                                    var5_4 /* !! */  = var3_3.mContext.getApplicationInfo().loadLabel(var3_3.mContext.getPackageManager());
                                                }
                                                var6_5 = var3_3.zzf(var4_2 /* !! */ , "gcm.n.body");
                                                var13_6 = zza.zze(var4_2 /* !! */ , "gcm.n.icon");
                                                var12_7 = var3_3;
                                                if (TextUtils.isEmpty((CharSequence)var13_6)) ** GOTO lbl21
                                                var14_8 /* !! */  = var12_7.mContext.getResources();
                                                var15_10 = var14_8 /* !! */ .getIdentifier(var13_6, "drawable", var12_7.mContext.getPackageName());
                                                if (var15_10 != 0) {
                                                    v0 = var15_10;
                                                } else {
                                                    var15_10 = var14_8 /* !! */ .getIdentifier(var13_6, "mipmap", var12_7.mContext.getPackageName());
                                                    if (var15_10 != 0) {
                                                        v0 = var15_10;
                                                    } else {
                                                        Log.w((String)"GcmNotification", (String)new StringBuilder(57 + String.valueOf(var13_6).length()).append("Icon resource ").append(var13_6).append(" not found. Notification will use app icon.").toString());
lbl21:
                                                        // 2 sources

                                                        if ((var14_9 = var12_7.mContext.getApplicationInfo().icon) == 0) {
                                                            var14_9 = 17301651;
                                                        }
                                                        v0 = var14_9;
                                                    }
                                                }
                                                var7_11 = v0;
                                                var8_13 = zza.zze(var4_2 /* !! */ , "gcm.n.color");
                                                var13_6 = zza.zze(var4_2 /* !! */ , "gcm.n.sound2");
                                                var12_7 = var3_3;
                                                if (TextUtils.isEmpty((CharSequence)var13_6)) {
                                                    v1 = null;
                                                } else if (!"default".equals(var13_6) && var12_7.mContext.getResources().getIdentifier(var13_6, "raw", var12_7.mContext.getPackageName()) != 0) {
                                                    var16_14 = "android.resource://";
                                                    var17_15 /* !! */  = var12_7.mContext.getPackageName();
                                                    v1 = Uri.parse((String)new StringBuilder(5 + String.valueOf(var16_14).length() + String.valueOf(var17_15 /* !! */ ).length() + String.valueOf(var13_6).length()).append(var16_14).append((String)var17_15 /* !! */ ).append("/raw/").append(var13_6).toString());
                                                } else {
                                                    v1 = RingtoneManager.getDefaultUri((int)2);
                                                }
                                                var9_16 = v1;
                                                var10_17 = var3_3.zzt(var4_2 /* !! */ );
                                                if (!zzq.isAtLeastO() || var3_3.mContext.getApplicationInfo().targetSdkVersion <= 25) break block24;
                                                var13_6 = zza.zze(var4_2 /* !! */ , "gcm.n.android_channel_id");
                                                var12_7 = var3_3;
                                                if (zzq.isAtLeastO()) break block25;
                                                v2 = null;
                                                break block26;
                                            }
                                            var14_8 /* !! */  = (NotificationManager)var12_7.mContext.getSystemService(NotificationManager.class);
                                            if (TextUtils.isEmpty((CharSequence)var13_6)) break block27;
                                            if (var14_8 /* !! */ .getNotificationChannel(var13_6) == null) break block28;
                                            v2 = var13_6;
                                            break block26;
                                        }
                                        Log.w((String)"GcmNotification", (String)new StringBuilder(122 + String.valueOf(var13_6).length()).append("Notification Channel requested (").append(var13_6).append(") has not been created by the app. Manifest configuration, or default, value will be used.").toString());
                                    }
                                    if (var12_7.zzibx == null) break block29;
                                    v2 = var12_7.zzibx;
                                    break block26;
                                }
                                var12_7.zzibx = var12_7.zzauu().getString("com.google.android.gms.gcm.default_notification_channel_id");
                                if (TextUtils.isEmpty((CharSequence)var12_7.zzibx)) break block30;
                                if (var14_8 /* !! */ .getNotificationChannel(var12_7.zzibx) == null) break block31;
                                v2 = var12_7.zzibx;
                                break block26;
                            }
                            Log.w((String)"GcmNotification", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
                            break block32;
                        }
                        Log.w((String)"GcmNotification", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
                    }
                    if (var14_8 /* !! */ .getNotificationChannel("fcm_fallback_notification_channel") == null) {
                        var14_8 /* !! */ .createNotificationChannel(new NotificationChannel("fcm_fallback_notification_channel", (CharSequence)var12_7.mContext.getString(R.string.gcm_fallback_notification_channel_label), 3));
                    }
                    v2 = var12_7.zzibx = "fcm_fallback_notification_channel";
                }
                var11_18 = v2;
                var19_19 = var11_18;
                var18_20 = var10_17;
                var17_15 /* !! */  = var9_16;
                var16_14 = var8_13;
                var15_10 = var7_11;
                var14_8 /* !! */  = var6_5;
                var13_6 = var5_4 /* !! */ ;
                var12_7 = var3_3;
                var20_21 = new Notification.Builder(var12_7.mContext).setAutoCancel(true).setSmallIcon(var15_10);
                if (!TextUtils.isEmpty((CharSequence)var13_6)) {
                    var20_21.setContentTitle((CharSequence)var13_6);
                }
                if (!TextUtils.isEmpty((CharSequence)var14_8 /* !! */ )) {
                    var20_21.setContentText((CharSequence)var14_8 /* !! */ );
                    var20_21.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)var14_8 /* !! */ ));
                }
                if (!TextUtils.isEmpty((CharSequence)var16_14)) {
                    var20_21.setColor(Color.parseColor((String)var16_14));
                }
                if (var17_15 /* !! */  != null) {
                    var20_21.setSound(var17_15 /* !! */ );
                }
                if (var18_20 != null) {
                    var20_21.setContentIntent(var18_20);
                }
                if (var19_19 != null) {
                    var20_21.setChannelId((String)var19_19);
                }
                v3 = var20_21.build();
                break block33;
            }
            var18_20 = var10_17;
            var17_15 /* !! */  = var9_16;
            var16_14 = var8_13;
            var15_10 = var7_11;
            var14_8 /* !! */  = var6_5;
            var13_6 = var5_4 /* !! */ ;
            var12_7 = var3_3;
            var19_19 = new NotificationCompat.Builder(var12_7.mContext).setAutoCancel(true).setSmallIcon(var15_10);
            if (!TextUtils.isEmpty((CharSequence)var13_6)) {
                var19_19.setContentTitle((CharSequence)var13_6);
            }
            if (!TextUtils.isEmpty((CharSequence)var14_8 /* !! */ )) {
                var19_19.setContentText((CharSequence)var14_8 /* !! */ );
            }
            if (!TextUtils.isEmpty((CharSequence)var16_14)) {
                var19_19.setColor(Color.parseColor((String)var16_14));
            }
            if (var17_15 /* !! */  != null) {
                var19_19.setSound(var17_15 /* !! */ );
            }
            if (var18_20 != null) {
                var19_19.setContentIntent(var18_20);
            }
            v3 = var19_19.build();
        }
        var2_22 = v3;
        var5_4 /* !! */  = var2_22;
        var4_2 /* !! */  = zza.zze(var1_1, "gcm.n.tag");
        var3_3 = this;
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        var6_5 = (NotificationManager)var3_3.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)var4_2 /* !! */ )) {
            var7_12 = SystemClock.uptimeMillis();
            var4_2 /* !! */  = new StringBuilder(37).append("GCM-Notification:").append(var7_12).toString();
        }
        var6_5.notify((String)var4_2 /* !! */ , 0, (Notification)var5_4 /* !! */ );
        return true;
    }

    private final String zzf(Bundle bundle, String string2) {
        String string3 = zza.zze(bundle, string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        String string4 = String.valueOf(string2);
        String string5 = String.valueOf("_loc_key");
        String string6 = zza.zze(bundle, string5.length() != 0 ? string4.concat(string5) : new String(string4));
        if (TextUtils.isEmpty((CharSequence)string6)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string6, "string", this.mContext.getPackageName());
        if (n == 0) {
            String string7 = String.valueOf(string2);
            String string8 = String.valueOf("_loc_key");
            String string9 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
            String string10 = string9.substring(6);
            Log.w((String)"GcmNotification", (String)new StringBuilder(49 + String.valueOf(string10).length() + String.valueOf(string6).length()).append(string10).append(" resource not found: ").append(string6).append(" Default value will be used.").toString());
            return null;
        }
        String string11 = String.valueOf(string2);
        String string12 = String.valueOf("_loc_args");
        String string13 = zza.zze(bundle, string12.length() != 0 ? string11.concat(string12) : new String(string11));
        if (TextUtils.isEmpty((CharSequence)string13)) {
            return resources.getString(n);
        }
        try {
            JSONArray jSONArray = new JSONArray(string13);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return resources.getString(n, objectArray);
        }
        catch (JSONException jSONException) {
            String string14 = String.valueOf(string2);
            String string15 = String.valueOf("_loc_args");
            String string16 = string15.length() != 0 ? string14.concat(string15) : new String(string14);
            String string17 = string16.substring(6);
            Log.w((String)"GcmNotification", (String)new StringBuilder(41 + String.valueOf(string17).length() + String.valueOf(string13).length()).append("Malformed ").append(string17).append(": ").append(string13).append("  Default value will be used.").toString());
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            Log.w((String)"GcmNotification", (String)new StringBuilder(58 + String.valueOf(string6).length() + String.valueOf(string13).length()).append("Missing format argument for ").append(string6).append(": ").append(string13).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
        }
        return null;
    }

    private final PendingIntent zzt(Bundle bundle) {
        Intent intent;
        String string2 = zza.zze(bundle, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            intent = new Intent(string2);
            intent.setPackage(this.mContext.getPackageName());
            intent.setFlags(0x10000000);
        } else {
            intent = this.mContext.getPackageManager().getLaunchIntentForPackage(this.mContext.getPackageName());
            if (intent == null) {
                Log.w((String)"GcmNotification", (String)"No activity found to launch app");
                return null;
            }
        }
        bundle = new Bundle(bundle);
        GcmListenerService.zzq(bundle);
        intent.putExtras(bundle);
        for (String string3 : bundle.keySet()) {
            if (!string3.startsWith("gcm.n.") && !string3.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string3);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zziby.getAndIncrement(), (Intent)intent, (int)0x40000000);
    }

    private final Bundle zzauu() {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (applicationInfo != null && applicationInfo.metaData != null) {
            return applicationInfo.metaData;
        }
        return Bundle.EMPTY;
    }
}

