/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.gcm.zza;
import com.google.android.gms.gcm.zzc;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.zzaa;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    @Deprecated
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    @Deprecated
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_EVENT = "send_event";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    public static final String INSTANCE_ID_SCOPE = "GCM";
    private static GoogleCloudMessaging zzika;
    private Context zzaiq;
    private PendingIntent zzikb;
    private final Map<String, Handler> zzikc = Collections.synchronizedMap(new ArrayMap());
    private static final AtomicInteger zzikd;
    private final BlockingQueue<Intent> zzike = new LinkedBlockingQueue<Intent>();
    private Messenger zzikf = new Messenger((Handler)new zzc(this, Looper.getMainLooper()));

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzika == null) {
            zzika = new GoogleCloudMessaging();
            new GoogleCloudMessaging().zzaiq = context.getApplicationContext();
        }
        return zzika;
    }

    public GoogleCloudMessaging() {
    }

    public void close() {
        zzika = null;
        zza.zzijk = null;
        this.zzawh();
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string2, String string3, Bundle bundle) throws IOException {
        this.send(string2, string3, -1L, bundle);
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string2, String string3, long l, Bundle bundle) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        String string4 = zzaa.zzdr((Context)this.zzaiq);
        if (string4 == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.zzg(intent);
        intent.setPackage(string4);
        intent.putExtra("google.to", string2);
        intent.putExtra("google.message_id", string3);
        intent.putExtra("google.ttl", Long.toString(l));
        String string5 = string2;
        GoogleCloudMessaging googleCloudMessaging = this;
        int n = string5.indexOf(64);
        String string6 = n > 0 ? string5.substring(0, n) : string5;
        InstanceID.getInstance((Context)googleCloudMessaging.zzaiq);
        intent.putExtra("google.from", InstanceID.zzawr().zzf("", string6, INSTANCE_ID_SCOPE));
        if (string4.contains(".gsf")) {
            Bundle bundle2 = new Bundle();
            for (String string7 : bundle.keySet()) {
                Object object = bundle.get(string7);
                if (!(object instanceof String)) continue;
                String string8 = String.valueOf(string7);
                bundle2.putString(string8.length() != 0 ? "gcm.".concat(string8) : new String("gcm."), (String)object);
            }
            bundle2.putString("google.to", string2);
            bundle2.putString("google.message_id", string3);
            InstanceID.getInstance((Context)this.zzaiq).zzb(INSTANCE_ID_SCOPE, "upstream", bundle2);
            return;
        }
        this.zzaiq.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private final boolean zzf(Intent intent) {
        Handler handler;
        String string2 = intent.getStringExtra("In-Reply-To");
        if (string2 == null && intent.hasExtra("error")) {
            string2 = intent.getStringExtra("google.message_id");
        }
        if (string2 != null && (handler = this.zzikc.remove(string2)) != null) {
            Message message = Message.obtain();
            Message.obtain().obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        InstanceID.getInstance((Context)this.zzaiq).deleteInstanceID();
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized String register(String ... stringArray) throws IOException {
        return this.zza(zzaa.zzdq((Context)this.zzaiq), stringArray);
    }

    @Deprecated
    @Hide
    private final synchronized String zza(boolean bl, String ... stringArray) throws IOException {
        String string2 = zzaa.zzdr((Context)this.zzaiq);
        if (string2 == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string3 = GoogleCloudMessaging.zzd(stringArray);
        Bundle bundle = new Bundle();
        if (string2.contains(".gsf")) {
            bundle.putString("legacy.sender", string3);
            return InstanceID.getInstance((Context)this.zzaiq).getToken(string3, INSTANCE_ID_SCOPE, bundle);
        }
        bundle.putString("sender", string3);
        String string4 = "registration_id";
        Intent intent = this.zza(bundle, bl);
        if (intent == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string5 = intent.getStringExtra(string4);
        if (string5 != null) {
            return string5;
        }
        String string6 = intent.getStringExtra("error");
        if (string6 != null) {
            throw new IOException(string6);
        }
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    @Deprecated
    private final Intent zza(Bundle bundle, boolean bl) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        if (GoogleCloudMessaging.zzdn(this.zzaiq) < 0) {
            throw new IOException("Google Play Services missing");
        }
        Intent intent = new Intent(bl ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzaa.zzdr((Context)this.zzaiq));
        this.zzg(intent);
        int n = zzikd.getAndIncrement();
        String string2 = new StringBuilder(21).append("google.rpc").append(n).toString();
        intent.putExtra("google.message_id", string2);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzikf);
        if (bl) {
            this.zzaiq.sendBroadcast(intent);
        } else {
            this.zzaiq.startService(intent);
        }
        try {
            return this.zzike.poll(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private static String zzd(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string2)) {
            return null;
        }
        String string3 = intent.getStringExtra("message_type");
        if (string3 != null) {
            return string3;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    private final synchronized void zzg(Intent intent) {
        if (this.zzikb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzikb = PendingIntent.getBroadcast((Context)this.zzaiq, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzikb);
    }

    private final synchronized void zzawh() {
        if (this.zzikb != null) {
            this.zzikb.cancel();
            this.zzikb = null;
        }
    }

    @Hide
    public static int zzdn(Context context) {
        String string2 = zzaa.zzdr((Context)context);
        if (string2 != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string2, 0);
                if (packageInfo != null) {
                    return packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return -1;
    }

    static /* synthetic */ BlockingQueue zza(GoogleCloudMessaging googleCloudMessaging) {
        return googleCloudMessaging.zzike;
    }

    static /* synthetic */ boolean zza(GoogleCloudMessaging googleCloudMessaging, Intent intent) {
        return googleCloudMessaging.zzf(intent);
    }

    static /* synthetic */ Context zzb(GoogleCloudMessaging googleCloudMessaging) {
        return googleCloudMessaging.zzaiq;
    }

    static {
        zzikd = new AtomicInteger(1);
    }
}

