/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzi;

public class Task
implements ReflectedParcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zziks;
    private final String mTag;
    private final boolean zzikt;
    private final boolean zziku;
    private final int zzikv;
    private final boolean zzikw;
    private final boolean zzikx;
    private final zzi zziky;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zziks = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzikt = builder.updateCurrent;
        this.zziku = builder.isPersisted;
        this.zzikv = builder.requiredNetworkState;
        this.zzikw = builder.requiresCharging;
        this.zzikx = false;
        this.mExtras = builder.extras;
        this.zziky = builder.zzikz != null ? builder.zzikz : zzi.zzikn;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zziks = parcel.readString();
        this.mTag = parcel.readString();
        this.zzikt = parcel.readInt() == 1;
        this.zziku = parcel.readInt() == 1;
        this.zzikv = 2;
        this.zzikw = false;
        this.zzikx = false;
        this.zziky = zzi.zzikn;
        this.mExtras = null;
    }

    @Hide
    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzikt);
        bundle.putBoolean("persisted", this.zziku);
        bundle.putString("service", this.zziks);
        bundle.putInt("requiredNetwork", this.zzikv);
        bundle.putBoolean("requiresCharging", this.zzikw);
        bundle.putBoolean("requiresIdle", false);
        bundle.putBundle("retryStrategy", this.zziky.zzv(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zziks;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzikt;
    }

    public boolean isPersisted() {
        return this.zziku;
    }

    public int getRequiredNetwork() {
        return this.zzikv;
    }

    public boolean getRequiresCharging() {
        return this.zzikw;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zziks);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzikt ? 1 : 0);
        parcel.writeInt(this.zziku ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    @Hide
    public static void zzw(Bundle bundle) {
        if (bundle != null) {
            Object object = bundle;
            Parcel parcel = Parcel.obtain();
            object.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            parcel.recycle();
            int n2 = n;
            if (n2 > 10240) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Extras exceeding maximum size(10240 bytes): ").append(n2).toString());
            }
            for (String string2 : bundle.keySet()) {
                Object object2 = bundle.get(string2);
                object = object2;
                if (object2 instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean) continue;
                if (object2 instanceof Bundle) {
                    Task.zzw((Bundle)object2);
                    continue;
                }
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, Boolean, and nested Bundles with the same restrictions.");
            }
        }
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        @Hide
        protected zzi zzikz = zzi.zzikn;
        protected Bundle extras;

        public Builder() {
        }

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzbq.checkArgument((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzid(this.tag);
            zzi zzi2 = this.zzikz;
            if (zzi2 != null) {
                int n = zzi2.zzawi();
                if (n != 1 && n != 0) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
                }
                int n2 = zzi2.zzawj();
                int n3 = zzi2.zzawk();
                if (n == 0 && n2 < 0) {
                    throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
                }
                if (n == 1 && n2 < 10) {
                    throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
                }
                if (n3 < n2) {
                    int n4 = zzi2.zzawk();
                    throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
                }
            }
            if (this.isPersisted) {
                Task.zzw(this.extras);
            }
        }
    }
}

