/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzi;

public class OneoffTask
extends Task {
    private final long zzaj;
    private final long zzak;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new zzi();

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzaj = builder.zzaj;
        this.zzak = builder.zzak;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zzaj = parcel.readLong();
        this.zzak = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzaj);
        bundle.putLong("window_end", this.zzak);
    }

    public long getWindowStart() {
        return this.zzaj;
    }

    public long getWindowEnd() {
        return this.zzak;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zzaj);
        parcel.writeLong(this.zzak);
    }

    public String toString() {
        String string2 = super.toString();
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string2).length()).append(string2).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    /* synthetic */ OneoffTask(Parcel parcel, zzi zzi2) {
        this(parcel);
    }

    /* synthetic */ OneoffTask(Builder builder, zzi zzi2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzaj = -1L;
        private long zzak = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzaj = l;
            this.zzak = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string2) {
            this.tag = string2;
            return this;
        }

        @Override
        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaj == -1L || this.zzak == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzaj >= this.zzak) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            ((Task.Builder)this).checkConditions();
            return new OneoffTask(this, null);
        }
    }
}

