/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzk;

public class PeriodicTask
extends Task {
    protected long mIntervalInSeconds = -1L;
    protected long mFlexInSeconds = -1L;
    public static final Parcelable.Creator<PeriodicTask> CREATOR = new zzk();

    private PeriodicTask(Builder builder) {
        super(builder);
        this.mIntervalInSeconds = builder.zzam;
        this.mFlexInSeconds = Math.min(builder.zzan, this.mIntervalInSeconds);
    }

    @Deprecated
    private PeriodicTask(Parcel parcel) {
        super(parcel);
        this.mIntervalInSeconds = parcel.readLong();
        this.mFlexInSeconds = Math.min(parcel.readLong(), this.mIntervalInSeconds);
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("period", this.mIntervalInSeconds);
        bundle.putLong("period_flex", this.mFlexInSeconds);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.mIntervalInSeconds);
        parcel.writeLong(this.mFlexInSeconds);
    }

    public long getPeriod() {
        return this.mIntervalInSeconds;
    }

    public long getFlex() {
        return this.mFlexInSeconds;
    }

    public String toString() {
        String string2 = super.toString();
        long l = this.getPeriod();
        long l2 = this.getFlex();
        return new StringBuilder(54 + String.valueOf(string2).length()).append(string2).append(" period=").append(l).append(" flex=").append(l2).toString();
    }

    /* synthetic */ PeriodicTask(Parcel parcel, zzk zzk2) {
        this(parcel);
    }

    /* synthetic */ PeriodicTask(Builder builder, zzk zzk2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzam = -1L;
        private long zzan = -1L;

        public Builder() {
            this.isPersisted = true;
        }

        public Builder setPeriod(long l) {
            this.zzam = l;
            return this;
        }

        public Builder setFlex(long l) {
            this.zzan = l;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string2) {
            this.tag = string2;
            return this;
        }

        @Override
        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        public PeriodicTask build() {
            ((Task.Builder)this).checkConditions();
            return new PeriodicTask(this, null);
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzam == -1L) {
                throw new IllegalArgumentException("Must call setPeriod(long) to establish an execution interval for this periodic task.");
            }
            if (this.zzam <= 0L) {
                long l = this.zzam;
                throw new IllegalArgumentException(new StringBuilder(66).append("Period set cannot be less than or equal to 0: ").append(l).toString());
            }
            if (this.zzan == -1L) {
                this.zzan = (long)((float)this.zzam * 0.1f);
                return;
            }
            if (this.zzan > this.zzam) {
                this.zzan = this.zzam;
            }
        }
    }
}

