/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzd;

public abstract class Task
implements Parcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzaJt;
    private final String mTag;
    private final boolean zzaJu;
    private final boolean zzaJv;
    private final int zzaJw;
    private final boolean zzaJx;
    private final zzd zzaJy;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzaJt = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzaJu = builder.updateCurrent;
        this.zzaJv = builder.isPersisted;
        this.zzaJw = builder.requiredNetworkState;
        this.zzaJx = builder.requiresCharging;
        this.zzaJy = builder.zzaJz;
        this.mExtras = builder.extras;
    }

    @Deprecated
    Task(Parcel in) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzaJt = in.readString();
        this.mTag = in.readString();
        this.zzaJu = in.readInt() == 1;
        this.zzaJv = in.readInt() == 1;
        this.zzaJw = 2;
        this.zzaJx = false;
        this.zzaJy = zzd.zzaJo;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzaJu);
        bundle.putBoolean("persisted", this.zzaJv);
        bundle.putString("service", this.zzaJt);
        bundle.putInt("requiredNetwork", this.zzaJw);
        bundle.putBoolean("requiresCharging", this.zzaJx);
        bundle.putBundle("retryStrategy", this.zzaJy.zzE(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzaJt;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzaJu;
    }

    public boolean isPersisted() {
        return this.zzaJv;
    }

    public int getRequiredNetwork() {
        return this.zzaJw;
    }

    public boolean getRequiresCharging() {
        return this.zzaJx;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.zzaJt);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzaJu ? 1 : 0);
        parcel.writeInt(this.zzaJv ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zza(zzd zzd2) {
        if (zzd2 != null) {
            int n = zzd2.zzxA();
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException("Must provide a valid RetryPolicy: " + n);
            }
            int n2 = zzd2.zzxB();
            int n3 = zzd2.zzxC();
            if (n == 0 && n2 < 0) {
                throw new IllegalArgumentException("InitialBackoffSeconds can't be negative: " + n2);
            }
            if (n == 1 && n2 < 10) {
                throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: " + zzd2.zzxC());
            }
        }
    }

    public static void zzF(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                throw new IllegalArgumentException("Extras exceeding maximum size(10240 bytes): " + n);
            }
            parcel.recycle();
            for (String string : bundle.keySet()) {
                if (Task.zzC(bundle.get(string))) continue;
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, and Boolean. ");
            }
        }
    }

    private static boolean zzC(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzd zzaJz = zzd.zzaJo;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        protected void checkConditions() {
            zzx.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzdE(this.tag);
            Task.zza(this.zzaJz);
            if (this.isPersisted) {
                Task.zzF(this.extras);
            }
        }
    }
}

