/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;

public class InstanceIDListenerService
extends Service {
    static String ACTION = "action";
    MessengerCompat zzaKj = new MessengerCompat(new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            InstanceIDListenerService.this.zza(msg, MessengerCompat.zzc(msg));
        }
    });
    BroadcastReceiver zzaKk = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string = intent.getStringExtra("registration_id");
                Log.d((String)"InstanceID", (String)("Received GSF callback using dynamic receiver: " + intent.getExtras()));
            }
            InstanceIDListenerService.this.zzp(intent);
            InstanceIDListenerService.this.stop();
        }
    };
    private static String zzaKl = "google.com/iid";
    private static String zzaKm = "CMD";
    private static String zzaIT = "gcm.googleapis.com/refresh";
    int zzaKn;
    int zzaKo;

    public void zzp(Intent intent) {
        Object object;
        String string = intent.getStringExtra("subtype");
        InstanceID instanceID = null;
        if (string == null) {
            instanceID = InstanceID.getInstance((Context)this);
        } else {
            object = new Bundle();
            object.putString("subtype", string);
            instanceID = InstanceID.zza((Context)this, object);
        }
        object = intent.getStringExtra(zzaKm);
        if (null != intent.getStringExtra("error") || null != intent.getStringExtra("registration_id")) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Register result in service " + string));
            }
            instanceID.zzxQ().zzx(intent);
            return;
        }
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            Log.d((String)"InstanceID", (String)("Service command " + string + " " + (String)object + " " + intent.getExtras()));
        }
        if (null != intent.getStringExtra("unregistered")) {
            instanceID.zzxP().zzdP(string == null ? "" : string);
            instanceID.zzxQ().zzx(intent);
            return;
        }
        if (zzaIT.equals(intent.getStringExtra("from"))) {
            instanceID.zzxP().zzdP(string);
            this.zzah(false);
            return;
        }
        if ("RST".equals(object)) {
            instanceID.zzxO();
            this.zzah(true);
        } else if ("RST_FULL".equals(object)) {
            if (!instanceID.zzxP().isEmpty()) {
                instanceID.zzxP().zzxU();
                this.zzah(true);
            }
        } else if ("SYNC".equals(object)) {
            instanceID.zzxP().zzdP(string);
            this.zzah(false);
        } else if ("PING".equals(object)) {
            try {
                GoogleCloudMessaging.getInstance((Context)this).send(zzaKl, zzc.zzxT(), 0L, intent.getExtras());
            }
            catch (IOException iOException) {
                Log.w((String)"InstanceID", (String)"Failed to send ping response");
            }
        }
    }

    static void zza(Context context, zzd zzd2) {
        zzd2.zzxU();
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.putExtra(zzaKm, "RST");
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }

    static void zzaL(Context context) {
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.setPackage(context.getPackageName());
        intent.putExtra(zzaKm, "SYNC");
        context.startService(intent);
    }

    private void zza(Message message, int n) {
        zzc.zzaM((Context)this);
        PackageManager packageManager = this.getPackageManager();
        if (n != zzc.zzaKv && n != zzc.zzaKu) {
            Log.w((String)"InstanceID", (String)("Message from unexpected caller " + n + " mine=" + zzc.zzaKu + " appid=" + zzc.zzaKv));
            return;
        }
        this.zzp((Intent)message.obj);
    }

    public void onCreate() {
        IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
        intentFilter.addCategory(this.getPackageName());
        this.registerReceiver(this.zzaKk, intentFilter, "com.google.android.c2dm.permission.RECEIVE", null);
    }

    public void onDestroy() {
        this.unregisterReceiver(this.zzaKk);
    }

    public IBinder onBind(Intent intent) {
        if (intent != null && "com.google.android.gms.iid.InstanceID".equals(intent.getAction())) {
            return this.zzaKj.getBinder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            --this.zzaKn;
            if (this.zzaKn == 0) {
                this.stopSelf(this.zzaKo);
            }
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Stop " + this.zzaKn + " " + this.zzaKo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzhc(int n) {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            ++this.zzaKn;
            if (n > this.zzaKo) {
                this.zzaKo = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzhc(startId);
        if (intent == null) {
            this.stop();
            return 2;
        }
        try {
            String string = intent.getAction();
            if ("com.google.android.gms.iid.InstanceID".equals(string)) {
                Intent intent2;
                if (Build.VERSION.SDK_INT <= 18 && (intent2 = (Intent)intent.getParcelableExtra("GSF")) != null) {
                    this.startService(intent2);
                    int n = 1;
                    return n;
                }
                this.zzp(intent);
            }
        }
        finally {
            this.stop();
        }
        if (intent.getStringExtra("from") != null) {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
        return 2;
    }

    public void zzah(boolean bl) {
        this.onTokenRefresh();
    }

    public void onTokenRefresh() {
    }
}

