/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;

public class GcmReceiver
extends WakefulBroadcastReceiver {
    private static String zzaLH = "gcm.googleapis.com/refresh";

    public void onReceive(Context context, Intent intent) {
        String string;
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        String string2 = intent.getStringExtra("from");
        if ("com.google.android.c2dm.intent.REGISTRATION".equals(intent.getAction()) || "google.com/iid".equals(string2) || zzaLH.equals(string2)) {
            intent.setAction("com.google.android.gms.iid.InstanceID");
        }
        if ((string = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        if ("com.google.android.c2dm.intent.RECEIVE".equals(intent.getAction())) {
            this.zzi(context, intent);
        } else {
            this.zzj(context, intent);
        }
        if (this.isOrderedBroadcast() && this.getResultCode() == 0) {
            this.setResultCode(-1);
        }
    }

    public void zzi(Context context, Intent intent) {
        this.zzj(context, intent);
    }

    private void zzj(Context context, Intent intent) {
        block9: {
            if (this.isOrderedBroadcast()) {
                this.setResultCode(500);
            }
            this.zzk(context, intent);
            try {
                ComponentName componentName;
                if (context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0) {
                    componentName = GcmReceiver.startWakefulService((Context)context, (Intent)intent);
                } else {
                    componentName = context.startService(intent);
                    Log.d((String)"GcmReceiver", (String)"Missing wake lock permission, service start may be delayed");
                }
                if (componentName == null) {
                    Log.e((String)"GcmReceiver", (String)"Error while delivering the message: ServiceIntent not found.");
                    if (this.isOrderedBroadcast()) {
                        this.setResultCode(404);
                    }
                } else if (this.isOrderedBroadcast()) {
                    this.setResultCode(-1);
                }
            }
            catch (SecurityException securityException) {
                Log.e((String)"GcmReceiver", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
                if (!this.isOrderedBroadcast()) break block9;
                this.setResultCode(401);
            }
        }
    }

    private void zzk(Context context, Intent intent) {
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"GcmReceiver", (String)"Failed to resolve target intent service, skipping classname enforcement");
            return;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (!context.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
            Log.e((String)"GcmReceiver", (String)("Error resolving target intent service, skipping classname enforcement. Resolved service was: " + serviceInfo.packageName + "/" + serviceInfo.name));
            return;
        }
        String string = serviceInfo.name;
        String string2 = string = string.startsWith(".") ? context.getPackageName() + string : string;
        if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
            Log.d((String)"GcmReceiver", (String)("Restricting intent to a specific service: " + string));
        }
        intent.setClassName(context.getPackageName(), string);
    }
}

