/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.gcm.GcmListenerService;
import java.util.Iterator;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

class zzb {
    static zzb zzaLC;
    private final Context mContext;
    private final Class<? extends GcmListenerService> zzaLD;

    static synchronized zzb zzc(Context context, Class<? extends GcmListenerService> clazz) {
        if (zzaLC == null) {
            zzaLC = new zzb(context, clazz);
        }
        return zzaLC;
    }

    static boolean zzy(Bundle bundle) {
        return "1".equals(zzb.zze(bundle, "gcm.n.e")) || zzb.zze(bundle, "gcm.n.icon") != null;
    }

    static boolean zzaI(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            return false;
        }
        int n = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    static void zzz(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            if (string2.startsWith("gcm.n.")) {
                string = string2.substring("gcm.n.".length());
                bundle2.putString(string, bundle.getString(string2));
                iterator.remove();
                continue;
            }
            if (!string2.startsWith("gcm.notification.")) continue;
            string = string2.substring("gcm.notification.".length());
            bundle2.putString(string, bundle.getString(string2));
            iterator.remove();
        }
        if (!bundle2.isEmpty()) {
            bundle.putBundle("notification", bundle2);
        }
    }

    static String zze(Bundle bundle, String string) {
        String string2 = bundle.getString(string);
        if (string2 == null) {
            string2 = bundle.getString(string.replace("gcm.n.", "gcm.notification."));
        }
        return string2;
    }

    private zzb(Context context, Class<? extends GcmListenerService> clazz) {
        this.mContext = context.getApplicationContext();
        this.zzaLD = clazz;
    }

    boolean zzA(Bundle bundle) {
        try {
            Notification notification = this.zzB(bundle);
            this.zza(zzb.zze(bundle, "gcm.n.tag"), notification);
            return true;
        }
        catch (zza zza2) {
            Log.e((String)"GcmNotification", (String)("Failed to show notification: " + zza2.getMessage()));
            return false;
        }
    }

    private Notification zzB(Bundle bundle) {
        String string = this.zzf(bundle, "gcm.n.title");
        String string2 = this.zzf(bundle, "gcm.n.body");
        int n = this.zzdW(zzb.zze(bundle, "gcm.n.icon"));
        String string3 = zzb.zze(bundle, "gcm.n.color");
        Uri uri = this.zzdX(zzb.zze(bundle, "gcm.n.sound2"));
        PendingIntent pendingIntent = this.zzC(bundle);
        PendingIntent pendingIntent2 = null;
        if (GcmListenerService.zzx(bundle)) {
            pendingIntent = this.zza(bundle, pendingIntent);
            pendingIntent2 = this.zzD(bundle);
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            builder.setContentTitle((CharSequence)string);
        } else {
            builder.setContentTitle(this.mContext.getApplicationInfo().loadLabel(this.mContext.getPackageManager()));
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setContentText((CharSequence)string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            builder.setColor(Color.parseColor((String)string3));
        }
        if (uri != null) {
            builder.setSound(uri);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent2);
        }
        return builder.build();
    }

    private void zza(String string, Notification notification) {
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "GCM-Notification:" + SystemClock.uptimeMillis();
        }
        notificationManager.notify(string, 0, notification);
    }

    private String zzf(Bundle bundle, String string) {
        String string2 = zzb.zze(bundle, string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        String string3 = zzb.zze(bundle, string + "_loc_key");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string3, "string", this.mContext.getPackageName());
        if (n == 0) {
            Log.w((String)"GcmNotification", (String)(this.zzdV(string + "_loc_key") + " resource not found: " + string3 + " Default value will be used."));
            return null;
        }
        String string4 = zzb.zze(bundle, string + "_loc_args");
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return resources.getString(n);
        }
        try {
            JSONArray jSONArray = new JSONArray(string4);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return resources.getString(n, objectArray);
        }
        catch (JSONException jSONException) {
            Log.w((String)"GcmNotification", (String)("Malformed " + this.zzdV(string + "_loc_args") + ": " + string4 + "  Default value will be used."));
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            Log.w((String)"GcmNotification", (String)("Missing format argument for " + string3 + ": " + string4 + " Default value will be used."), (Throwable)missingFormatArgumentException);
        }
        return null;
    }

    private String zzdV(String string) {
        return string.substring("gcm.n.".length());
    }

    private int zzdW(String string) {
        int n;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Resources resources = this.mContext.getResources();
            int n2 = resources.getIdentifier(string, "drawable", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            n2 = resources.getIdentifier(string, "mipmap", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            Log.w((String)"GcmNotification", (String)("Icon resource " + string + " not found. Notification will use app icon."));
        }
        if ((n = this.mContext.getApplicationInfo().icon) == 0) {
            n = 17301651;
        }
        return n;
    }

    private Uri zzdX(String string) {
        Resources resources;
        int n;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (!"default".equals(string) && (n = (resources = this.mContext.getResources()).getIdentifier(string, "raw", this.mContext.getPackageName())) != 0) {
            return Uri.parse((String)("android.resource://" + this.mContext.getPackageName() + "/raw/" + string));
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    private PendingIntent zzC(Bundle bundle) {
        Intent intent;
        String string = zzb.zze(bundle, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            intent = new Intent(string);
            intent.setPackage(this.mContext.getPackageName());
            intent.setFlags(0x10000000);
        } else {
            PackageManager packageManager = this.mContext.getPackageManager();
            intent = packageManager.getLaunchIntentForPackage(this.mContext.getPackageName());
            if (intent == null) {
                Log.w((String)"GcmNotification", (String)"No activity found to launch app");
                return null;
            }
        }
        bundle = new Bundle(bundle);
        GcmListenerService.zzw(bundle);
        intent.putExtras(bundle);
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("gcm.n.") && !string2.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string2);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzyj(), (Intent)intent, (int)0x40000000);
    }

    private PendingIntent zza(Bundle bundle, PendingIntent pendingIntent) {
        Intent intent = new Intent("com.google.android.gms.gcm.NOTIFICATION_OPEN");
        this.zza(intent, bundle);
        intent.putExtra("com.google.android.gms.gcm.PENDING_INTENT", (Parcelable)pendingIntent);
        return PendingIntent.getService((Context)this.mContext, (int)this.zzyj(), (Intent)intent, (int)0x40000000);
    }

    private PendingIntent zzD(Bundle bundle) {
        Intent intent = new Intent("com.google.android.gms.gcm.NOTIFICATION_DISMISS");
        this.zza(intent, bundle);
        return PendingIntent.getService((Context)this.mContext, (int)this.zzyj(), (Intent)intent, (int)0x40000000);
    }

    private void zza(Intent intent, Bundle bundle) {
        intent.setClass(this.mContext, this.zzaLD);
        for (String string : bundle.keySet()) {
            if (!string.startsWith("google.c.a.") && !string.equals("from")) continue;
            intent.putExtra(string, bundle.getString(string));
        }
    }

    private int zzyj() {
        return (int)SystemClock.uptimeMillis();
    }

    private class zza
    extends IllegalArgumentException {
    }
}

