/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.annotation.TargetApi;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.iid.zzb;

public class MessengerCompat
implements Parcelable {
    Messenger zzaNd;
    zzb zzaNe;
    public static final Parcelable.Creator<MessengerCompat> CREATOR = new Parcelable.Creator<MessengerCompat>(){

        public MessengerCompat zzeO(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            return iBinder != null ? new MessengerCompat(iBinder) : null;
        }

        public MessengerCompat[] zzhm(int n) {
            return new MessengerCompat[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzhm(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeO(parcel);
        }
    };

    public MessengerCompat(Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzaNd = new Messenger(handler);
        } else {
            this.zzaNe = new zza(handler);
        }
    }

    public MessengerCompat(IBinder target) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzaNd = new Messenger(target);
        } else {
            this.zzaNe = zzb.zza.zzcd(target);
        }
    }

    public static int zzc(Message message) {
        if (Build.VERSION.SDK_INT >= 21) {
            return MessengerCompat.zzd(message);
        }
        return message.arg2;
    }

    @TargetApi(value=21)
    private static int zzd(Message message) {
        return message.sendingUid;
    }

    public void send(Message message) throws RemoteException {
        if (this.zzaNd != null) {
            this.zzaNd.send(message);
        } else {
            this.zzaNe.send(message);
        }
    }

    public IBinder getBinder() {
        return this.zzaNd != null ? this.zzaNd.getBinder() : this.zzaNe.asBinder();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        try {
            return this.getBinder().equals(((MessengerCompat)otherObj).getBinder());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.getBinder().hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (this.zzaNd != null) {
            out.writeStrongBinder(this.zzaNd.getBinder());
        } else {
            out.writeStrongBinder(this.zzaNe.asBinder());
        }
    }

    private final class zza
    extends zzb.zza {
        Handler handler;

        zza(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void send(Message msg) throws RemoteException {
            msg.arg2 = Binder.getCallingUid();
            this.handler.dispatchMessage(msg);
        }
    }
}

