/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.zza;
import java.util.Iterator;

public abstract class GcmListenerService
extends Service {
    private final Object zzpp = new Object();
    private int zzaSJ;
    private int zzaSK = 0;

    public void onMessageReceived(String string, Bundle bundle) {
    }

    public void onDeletedMessages() {
    }

    public void onMessageSent(String string) {
    }

    public void onSendError(String string, String string2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent intent, int n, int n2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzaSJ = n2;
            ++this.zzaSK;
        }
        if (intent == null) {
            this.zzBL();
            return 2;
        }
        this.zzl(intent);
        return 3;
    }

    public final IBinder onBind(Intent intent) {
        return null;
    }

    @TargetApi(value=11)
    private void zzl(final Intent intent) {
        if (Build.VERSION.SDK_INT >= 11) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    GcmListenerService.this.zzm(intent);
                }
            });
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void zza(Void ... voidArray) {
                    GcmListenerService.this.zzm(intent);
                    return null;
                }

                protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                    return this.zza((Void[])objectArray);
                }
            }.execute((Object[])new Void[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzm(Intent intent) {
        try {
            switch (intent.getAction()) {
                case "com.google.android.c2dm.intent.RECEIVE": {
                    this.zzn(intent);
                    break;
                }
                default: {
                    String string = String.valueOf(intent.getAction());
                    Log.d((String)"GcmListenerService", (String)(string.length() != 0 ? "Unknown intent action: ".concat(string) : new String("Unknown intent action: ")));
                }
            }
            this.zzBL();
        }
        finally {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void zzn(Intent intent) {
        String string = intent.getStringExtra("message_type");
        if (string == null) {
            string = "gcm";
        }
        switch (string) {
            case "gcm": {
                this.zzo(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(intent.getStringExtra("google.message_id"), intent.getStringExtra("error"));
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                Log.w((String)"GcmListenerService", (String)(string2.length() != 0 ? "Received message with unknown type: ".concat(string2) : new String("Received message with unknown type: ")));
            }
        }
    }

    private void zzo(Intent intent) {
        Bundle bundle = intent.getExtras();
        bundle.remove("message_type");
        bundle.remove("android.support.content.wakelockid");
        if (zza.zzA(bundle)) {
            if (!zza.zzaR((Context)this)) {
                zza.zzaQ((Context)this).zzC(bundle);
                return;
            }
            zza.zzB(bundle);
        }
        String string = bundle.getString("from");
        bundle.remove("from");
        GcmListenerService.zzz(bundle);
        this.onMessageReceived(string, bundle);
    }

    static void zzz(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || !string.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzBL() {
        Object object = this.zzpp;
        synchronized (object) {
            --this.zzaSK;
            if (this.zzaSK == 0) {
                this.zzhE(this.zzaSJ);
            }
        }
    }

    boolean zzhE(int n) {
        return this.stopSelfResult(n);
    }
}

