/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class OneoffTask
extends Task {
    private final long zzaTg;
    private final long zzaTh;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new Parcelable.Creator<OneoffTask>(){

        public OneoffTask zzeM(Parcel parcel) {
            return new OneoffTask(parcel);
        }

        public OneoffTask[] zzhH(int n) {
            return new OneoffTask[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzhH(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeM(parcel);
        }
    };

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzaTg = builder.zzaTi;
        this.zzaTh = builder.zzaTj;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zzaTg = parcel.readLong();
        this.zzaTh = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzaTg);
        bundle.putLong("window_end", this.zzaTh);
    }

    public long getWindowStart() {
        return this.zzaTg;
    }

    public long getWindowEnd() {
        return this.zzaTh;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zzaTg);
        parcel.writeLong(this.zzaTh);
    }

    public String toString() {
        String string = String.valueOf(super.toString());
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string).length()).append(string).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaTi = -1L;
        private long zzaTj = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzaTi = l;
            this.zzaTj = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        @Override
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaTi == -1L || this.zzaTj == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzaTi >= this.zzaTj) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this);
        }
    }
}

