/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzf;
import com.google.android.gms.iid.zzg;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public final class zze {
    private static String zzbgZ = null;
    private static boolean zzbha = false;
    private static int zzbhb = 0;
    private static int zzbhc = 0;
    private static int zzbhd = 0;
    private static BroadcastReceiver zzbhe = null;
    private Context zzqD;
    private Map<String, Object> zzbhf = new HashMap<String, Object>();
    private Messenger zzbfT;
    private Messenger zzbhg;
    private MessengerCompat zzbhh;
    private PendingIntent zzbfP;
    private long zzbhi;
    private long zzbhj;
    private int zzbhk;
    private int zzbhl;
    private long zzbhm;

    public zze(Context context) {
        this.zzqD = context;
    }

    public static boolean zzbc(Context context) {
        if (zzbgZ != null) {
            zze.zzbd(context);
        }
        return zzbha;
    }

    public static String zzbd(Context context) {
        if (zzbgZ != null) {
            return zzbgZ;
        }
        zzbhb = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        if (zzq.isAtLeastO() ? zze.zzb(packageManager) || zze.zza(packageManager) : zze.zza(packageManager) || zze.zzb(packageManager)) {
            return zzbgZ;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve IID implementation package, falling back");
        if (zze.zzb(packageManager, "com.google.android.gms")) {
            zzbha = zzq.isAtLeastO();
            return zzbgZ;
        }
        if (Build.VERSION.SDK_INT < 21 && zze.zzb(packageManager, "com.google.android.gsf")) {
            zzbha = false;
            return zzbgZ;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Google Play services is missing, unable to get tokens");
        return null;
    }

    private static boolean zza(PackageManager packageManager) {
        Iterator iterator = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0).iterator();
        while (iterator.hasNext()) {
            String string = ((ResolveInfo)iterator.next()).serviceInfo.packageName;
            if (!zze.zza(packageManager, string, "com.google.android.c2dm.intent.REGISTER")) continue;
            zzbha = false;
            return true;
        }
        return false;
    }

    private static boolean zzb(PackageManager packageManager) {
        Iterator iterator = packageManager.queryBroadcastReceivers(new Intent("com.google.iid.TOKEN_REQUEST"), 0).iterator();
        while (iterator.hasNext()) {
            String string = ((ResolveInfo)iterator.next()).activityInfo.packageName;
            if (!zze.zza(packageManager, string, "com.google.iid.TOKEN_REQUEST")) continue;
            zzbha = true;
            return true;
        }
        return false;
    }

    private static boolean zza(PackageManager packageManager, String string, String string2) {
        if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.SEND", string)) {
            return zze.zzb(packageManager, string);
        }
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        return false;
    }

    private static boolean zzb(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            zzbgZ = applicationInfo.packageName;
            zzbhc = applicationInfo.uid;
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static int zzbe(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            return packageManager.getPackageInfo((String)zze.zzbd((Context)context), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    private static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            Signature signature = Signature.getInstance(privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA");
            signature.initSign(privateKey);
            signature.update(byArray);
            return InstanceID.zzj(signature.sign());
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    private final void zzvN() {
        if (this.zzbfT != null) {
            return;
        }
        zze.zzbd(this.zzqD);
        this.zzbfT = new Messenger((Handler)new zzf(this, Looper.getMainLooper()));
    }

    public final void zzc(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzbhh = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzbhg = (Messenger)parcelable;
                }
            }
            this.zzi((Intent)message.obj);
            return;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
    }

    private final synchronized void zzg(Intent intent) {
        if (this.zzbfP == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzbfP = PendingIntent.getBroadcast((Context)this.zzqD, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzbfP);
    }

    static String zzh(Intent intent) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        intent.getLongExtra("Retry-After", 0L);
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzB(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.zzbhf.keySet()) {
                Object object2 = this.zzbhf.get(string);
                this.zzbhf.put(string, object);
                zze.zze(object2, object);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzbhf.get(string);
            this.zzbhf.put(string, object);
            zze.zze(object2, object);
            return;
        }
    }

    private static void zze(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            Message.obtain().obj = object2;
            try {
                messenger.send(message);
                return;
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    public final void zzi(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string) && !"com.google.android.gms.iid.InstanceID".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            Intent intent2 = intent;
            zze zze2 = this;
            String string4 = intent2.getStringExtra("error");
            if (string4 == null) {
                String string5 = String.valueOf(intent2.getExtras());
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                return;
            }
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string6 = String.valueOf(string4);
                Log.d((String)"InstanceID/Rpc", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
            }
            String string7 = null;
            if (string4.startsWith("|")) {
                String[] stringArray = string4.split("\\|");
                if (!"ID".equals(stringArray[1])) {
                    String string8 = String.valueOf(string4);
                    Log.w((String)"InstanceID/Rpc", (String)(string8.length() != 0 ? "Unexpected structured response ".concat(string8) : new String("Unexpected structured response ")));
                }
                if (stringArray.length > 2) {
                    string7 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                } else {
                    string4 = "UNKNOWN";
                }
                intent2.putExtra("error", string4);
            }
            if (string7 == null) {
                zze2.zzB(string4);
            } else {
                zze2.zzi(string7, string4);
            }
            long l = intent2.getLongExtra("Retry-After", 0L);
            if (l > 0L) {
                zze2.zzbhj = SystemClock.elapsedRealtime();
                zze2.zzbhl = (int)l * 1000;
                zze2.zzbhm = SystemClock.elapsedRealtime() + (long)zze2.zzbhl;
                int n = zze2.zzbhl;
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
                return;
            }
            if ("SERVICE_NOT_AVAILABLE".equals(string4) || "AUTHENTICATION_FAILED".equals(string4)) {
                String string9 = string4;
                zze zze3 = zze2;
                if ("com.google.android.gsf".equals(zzbgZ)) {
                    ++zze3.zzbhk;
                    if (zze3.zzbhk >= 3) {
                        if (zze3.zzbhk == 3) {
                            zze3.zzbhl = 1000 + new Random().nextInt(1000);
                        }
                        zze3.zzbhl <<= 1;
                        zze3.zzbhm = SystemClock.elapsedRealtime() + (long)zze3.zzbhl;
                        int n = zze3.zzbhl;
                        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string9).length()).append("Backoff due to ").append(string9).append(" for ").append(n).toString());
                    }
                }
            }
            return;
        }
        this.zzbhi = SystemClock.elapsedRealtime();
        this.zzbhm = 0L;
        this.zzbhk = 0;
        this.zzbhl = 0;
        String string10 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string11 = String.valueOf(string3);
                Log.w((String)"InstanceID/Rpc", (String)(string11.length() != 0 ? "Unexpected structured response ".concat(string11) : new String("Unexpected structured response ")));
            }
            string10 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    Context context = this.zzqD;
                    Intent intent3 = new Intent("com.google.android.gms.iid.InstanceID");
                    intent3.putExtra("CMD", "SYNC");
                    intent3.setClassName(context, "com.google.android.gms.gcm.GcmReceiver");
                    context.sendBroadcast(intent3);
                } else if ("RST".equals(stringArray[3])) {
                    InstanceID.getInstance(this.zzqD);
                    InstanceIDListenerService.zza(this.zzqD, InstanceID.zzvM());
                    intent.removeExtra("registration_id");
                    this.zzi(string10, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (string10 == null) {
            this.zzB(intent);
            return;
        }
        this.zzi(string10, intent);
    }

    final Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger") && (intent = this.zzb(bundle, keyPair)) != null && intent.hasExtra("google.messenger")) {
            intent = null;
        }
        return intent;
    }

    private static synchronized String zzvO() {
        return Integer.toString(zzbhd++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        Class<?> clazz;
        String string;
        ConditionVariable conditionVariable;
        block24: {
            String string2;
            boolean bl;
            zze zze2;
            Intent intent;
            block25: {
                conditionVariable = new ConditionVariable();
                string = zze.zzvO();
                clazz = this.getClass();
                // MONITORENTER : clazz
                this.zzbhf.put(string, conditionVariable);
                // MONITOREXIT : clazz
                String string3 = string;
                KeyPair keyPair2 = keyPair;
                Bundle bundle2 = bundle;
                zze zze3 = this;
                long l = SystemClock.elapsedRealtime();
                if (zze3.zzbhm != 0L && l <= zze3.zzbhm) {
                    long l2 = zze3.zzbhm - l;
                    int n = zze3.zzbhl;
                    Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
                    throw new IOException("RETRY_LATER");
                }
                zze3.zzvN();
                if (zzbgZ == null) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                zze3.zzbhi = SystemClock.elapsedRealtime();
                Intent intent2 = new Intent(zzbha ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
                intent2.setPackage(zzbgZ);
                int n = zze.zzbe(zze3.zzqD);
                bundle2.putString("gmsv", Integer.toString(n));
                bundle2.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
                bundle2.putString("app_ver", Integer.toString(InstanceID.zzba(zze3.zzqD)));
                bundle2.putString("app_ver_name", InstanceID.zzbb(zze3.zzqD));
                bundle2.putString("cliv", "iid-11020000");
                bundle2.putString("appid", InstanceID.zza(keyPair2));
                String string4 = InstanceID.zzj(keyPair2.getPublic().getEncoded());
                bundle2.putString("pub2", string4);
                bundle2.putString("sig", zze.zza(keyPair2, zze3.zzqD.getPackageName(), string4));
                intent2.putExtras(bundle2);
                zze3.zzg(intent2);
                String string5 = string3;
                intent = intent2;
                zze2 = zze3;
                zze3.zzbhi = SystemClock.elapsedRealtime();
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string5).length()).append("|ID|").append(string5).append("|").toString());
                intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string5).length()).append("|ID|").append(string5).append("|").toString());
                bl = "com.google.android.gsf".equals(zzbgZ);
                String string6 = intent.getStringExtra("useGsf");
                if (string6 != null) {
                    bl = "1".equals(string6);
                }
                if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                if (zze2.zzbhg != null) {
                    intent.putExtra("google.messenger", (Parcelable)zze2.zzbfT);
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        zze2.zzbhg.send((Message)string2);
                        break block24;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block25;
                        Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (bl) {
                zze zze4;
                zze zze5 = zze4 = zze2;
                // MONITORENTER : zze4
                if (zzbhe == null) {
                    zzbhe = new zzg(zze4);
                    if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                        Log.d((String)"InstanceID/Rpc", (String)"Registered GSF callback receiver");
                    }
                    IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
                    intentFilter.addCategory(zze4.zzqD.getPackageName());
                    zze4.zzqD.registerReceiver(zzbhe, intentFilter, "com.google.android.c2dm.permission.SEND", null);
                }
                // MONITOREXIT : zze5
                zze2.zzqD.sendBroadcast(intent);
            } else {
                block26: {
                    intent.putExtra("google.messenger", (Parcelable)zze2.zzbfT);
                    intent.putExtra("messenger2", "1");
                    if (zze2.zzbhh != null) {
                        string2 = Message.obtain();
                        Message.obtain().obj = intent;
                        try {
                            zze2.zzbhh.send((Message)string2);
                            break block24;
                        }
                        catch (RemoteException remoteException) {
                            if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block26;
                            Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                        }
                    }
                }
                if (zzbha) {
                    zze2.zzqD.sendBroadcast(intent);
                } else {
                    zze2.zzqD.startService(intent);
                }
            }
        }
        conditionVariable.block(30000L);
        clazz = this.getClass();
        // MONITORENTER : clazz
        Object object = this.zzbhf.remove(string);
        if (object instanceof Intent) {
            // MONITOREXIT : clazz
            return (Intent)object;
        }
        if (object instanceof String) {
            throw new IOException((String)object);
        }
        String string7 = String.valueOf(object);
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(12 + String.valueOf(string7).length()).append("No response ").append(string7).toString());
        throw new IOException("TIMEOUT");
    }
}

