/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zza;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class zzo {
    private SharedPreferences zzige;
    private Context zzair;

    public zzo(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    private zzo(Context context, String string) {
        block4: {
            this.zzair = context;
            this.zzige = context.getSharedPreferences(string, 0);
            String string2 = String.valueOf(string);
            String string3 = String.valueOf("-no-backup");
            String string4 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            zzo zzo2 = this;
            File file = zzv.getNoBackupFilesDir((Context)zzo2.zzair);
            File file2 = new File(file, string4);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzo2.isEmpty()) {
                        Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                        InstanceIDListenerService.zza(zzo2.zzair, zzo2);
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                    String string5 = String.valueOf(iOException.getMessage());
                    Log.d((String)"InstanceID/Store", (String)(string5.length() != 0 ? "Error creating file in no backup dir: ".concat(string5) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final boolean isEmpty() {
        return this.zzige.getAll().isEmpty();
    }

    private static String zzd(String string, String string2, String string3) {
        String string4 = "|T|";
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string4).append(string2).append("|").append(string3).toString();
    }

    final synchronized String get(String string, String string2) {
        String string3 = "|S|";
        return this.zzige.getString(new StringBuilder(String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string).append(string3).append(string2).toString(), null);
    }

    final synchronized String get(String string) {
        return this.zzige.getString(string, null);
    }

    private final synchronized void zza(SharedPreferences.Editor editor, String string, String string2, String string3) {
        String string4 = "|S|";
        editor.putString(new StringBuilder(String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string).append(string4).append(string2).toString(), string3);
    }

    public final synchronized void zzhz(String string) {
        SharedPreferences.Editor editor = this.zzige.edit();
        for (String string2 : this.zzige.getAll().keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public final synchronized void zzavj() {
        this.zzige.edit().clear().commit();
    }

    public final synchronized String zze(String string, String string2, String string3) {
        String string4 = zzo.zzd(string, string2, string3);
        return this.zzige.getString(string4, null);
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzo.zzd(string, string2, string3);
        SharedPreferences.Editor editor = this.zzige.edit();
        editor.putString(string6, string4);
        editor.putString("appVersion", string5);
        editor.putString("lastToken", Long.toString(System.currentTimeMillis() / 1000L));
        editor.commit();
    }

    public final synchronized void zzf(String string, String string2, String string3) {
        String string4 = zzo.zzd(string, string2, string3);
        SharedPreferences.Editor editor = this.zzige.edit();
        editor.remove(string4);
        editor.commit();
    }

    final synchronized KeyPair zzc(String string, long l) {
        KeyPair keyPair = zza.zzavc();
        SharedPreferences.Editor editor = this.zzige.edit();
        this.zza(editor, string, "|P|", InstanceID.zzo(keyPair.getPublic().getEncoded()));
        this.zza(editor, string, "|K|", InstanceID.zzo(keyPair.getPrivate().getEncoded()));
        this.zza(editor, string, "cre", Long.toString(l));
        editor.commit();
        return keyPair;
    }

    public final void zzia(String string) {
        this.zzhz(String.valueOf(string).concat("|T|"));
    }

    final KeyPair zzib(String string) {
        String string2 = this.get(string, "|P|");
        String string3 = this.get(string, "|K|");
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"InstanceID/Store", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            InstanceIDListenerService.zza(this.zzair, this);
            return null;
        }
    }
}

