/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zzaa;
import com.google.android.gms.iid.zzaf;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    private static Map<String, InstanceID> zzimu = new ArrayMap();
    private Context mContext;
    private static zzaf zzimv;
    private static zzaa zzimw;
    private KeyPair zzimx;
    private String zzimy = "";
    private long zzimz;
    private static String zzina;

    @Hide
    private InstanceID(Context context, String string) {
        this.mContext = context.getApplicationContext();
        this.zzimy = string;
    }

    static int zzdo(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzdp(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.getInstance(context, null);
    }

    @Hide
    @KeepForSdk
    public static synchronized InstanceID getInstance(Context context, Bundle bundle) {
        String string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzimv == null) {
            zzimv = new zzaf(context);
            zzimw = new zzaa(context);
        }
        zzina = Integer.toString(InstanceID.zzdo(context));
        InstanceID instanceID = zzimu.get(string);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string);
            zzimu.put(string, instanceID);
        }
        return instanceID;
    }

    static String zzp(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    private final KeyPair zzawp() {
        if (this.zzimx == null) {
            String string = this.zzimy;
            this.zzimx = zzimv.zzii(string);
        }
        if (this.zzimx == null) {
            this.zzimz = System.currentTimeMillis();
            this.zzimx = zzimv.zzc(this.zzimy, this.zzimz);
        }
        return this.zzimx;
    }

    @Hide
    @KeepForSdk
    public String getSubtype() {
        return this.zzimy;
    }

    public String getId() {
        return InstanceID.zza(this.zzawp());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string;
        if (this.zzimz == 0L && (string = zzimv.get(this.zzimy, "cre")) != null) {
            this.zzimz = Long.parseLong(string);
        }
        return this.zzimz;
    }

    public void deleteInstanceID() throws IOException {
        this.zza("*", "*", null);
        this.zzawq();
    }

    @Hide
    public final void zzawq() {
        this.zzimz = 0L;
        String string = this.zzimy;
        zzimv.zzih(String.valueOf(string).concat("|"));
        this.zzimx = null;
    }

    public void deleteToken(String string, String string2) throws IOException {
        this.zza(string, string2, null);
    }

    @Hide
    public final void zza(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzimv.zzg(this.zzimy, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzimy) ? string : this.zzimy);
        bundle.putString("X-subtype", "".equals(this.zzimy) ? string : this.zzimy);
        zzaa.zzy(zzimw.zza(bundle, this.zzawp()));
    }

    @Hide
    public static zzaf zzawr() {
        return zzimv;
    }

    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        boolean bl;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl2 = true;
        String string4 = zzimv.get("appVersion");
        if (string4 == null || !string4.equals(zzina)) {
            bl = true;
        } else {
            String string5 = zzimv.get("lastToken");
            if (string5 == null) {
                bl = true;
            } else {
                Long l = Long.parseLong(string5);
                bl = System.currentTimeMillis() / 1000L - l > 604800L;
            }
        }
        if ((string3 = bl ? null : zzimv.zzf(this.zzimy, string, string2)) != null) {
            return string3;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (bundle.getString("ttl") != null) {
            bl2 = false;
        }
        if ("jwt".equals(bundle.getString("type"))) {
            bl2 = false;
        }
        if ((string3 = this.zzb(string, string2, bundle)) != null && bl2) {
            zzimv.zza(this.zzimy, string, string2, string3, zzina);
        }
        return string3;
    }

    @Hide
    public final String zzb(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        String string4;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string5 = string4 = "".equals(this.zzimy) ? string : this.zzimy;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string4);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string4);
        }
        if ("RST".equals(string3 = zzaa.zzy(zzimw.zza(bundle, this.zzawp()))) || string3.startsWith("RST|")) {
            InstanceIDListenerService.zza(this.mContext, zzimv);
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        return string3;
    }
}

