/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.iid.zzm;
import com.google.android.gms.iid.zzn;
import com.google.android.gms.iid.zzp;
import com.google.android.gms.iid.zzq;
import com.google.android.gms.iid.zzr;
import com.google.android.gms.iid.zzt;
import com.google.android.gms.iid.zzu;
import com.google.android.gms.iid.zzv;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class zzo
implements ServiceConnection {
    int state = 0;
    final Messenger zzing = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzp(this)));
    zzt zzinh;
    final Queue<zzu<?>> zzini = new ArrayDeque();
    final SparseArray<zzu<?>> zzinj = new SparseArray();
    final /* synthetic */ zzm zzink;

    private zzo(zzm zzm2) {
        this.zzink = zzm2;
    }

    final synchronized boolean zzb(zzu zzu2) {
        switch (this.state) {
            case 0: {
                this.zzini.add(zzu2);
                zzo zzo2 = this;
                zzbq.checkState((zzo2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzo2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!zza.zzanm().zza(zzm.zza(zzo2.zzink), intent, (ServiceConnection)zzo2, 1)) {
                    zzo2.zzl(0, "Unable to bind to service");
                } else {
                    zzm.zzb(zzo2.zzink).schedule(new zzq(zzo2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzini.add(zzu2);
                return true;
            }
            case 2: {
                this.zzini.add(zzu2);
                this.zzawt();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zzc(Message message) {
        zzu zzu2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzo zzo2 = this;
        synchronized (zzo2) {
            zzu2 = (zzu)this.zzinj.get(n);
            if (zzu2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzinj.remove(n);
            this.zzawu();
        }
        Bundle bundle = message.getData();
        zzu zzu3 = zzu2;
        if (bundle.getBoolean("unsupported", false)) {
            zzu3.zzb(new zzv(4, "Not supported by GmsCore"));
        } else {
            zzu3.zzx(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zzl(0, "Null service connection");
            return;
        }
        try {
            this.zzinh = new zzt(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zzl(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzawt();
    }

    private final void zzawt() {
        zzm.zzb(this.zzink).execute(new zzr(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zzl(2, "Service disconnected");
    }

    final synchronized void zzl(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                zza.zzanm();
                zzo zzo2 = this;
                Context context = zzm.zza(this.zzink);
                context.unbindService((ServiceConnection)zzo2);
                this.zza(new zzv(n, string));
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    private final void zza(zzv zzv2) {
        Iterator iterator = this.zzini.iterator();
        while (iterator.hasNext()) {
            ((zzu)iterator.next()).zzb(zzv2);
        }
        this.zzini.clear();
        for (int i = 0; i < this.zzinj.size(); ++i) {
            ((zzu)this.zzinj.valueAt(i)).zzb(zzv2);
        }
        this.zzinj.clear();
    }

    final synchronized void zzawu() {
        if (this.state == 2 && this.zzini.isEmpty() && this.zzinj.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            zza.zzanm();
            zzo zzo2 = this;
            Context context = zzm.zza(this.zzink);
            context.unbindService((ServiceConnection)zzo2);
        }
    }

    final synchronized void zzawv() {
        if (this.state == 1) {
            this.zzl(1, "Timed out while binding");
        }
    }

    final synchronized void zzec(int n) {
        zzu zzu2 = (zzu)this.zzinj.get(n);
        if (zzu2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzinj.remove(n);
            zzu2.zzb(new zzv(3, "Timed out waiting for response"));
            this.zzawu();
        }
    }

    /* synthetic */ zzo(zzm zzm2, zzn zzn2) {
        this(zzm2);
    }
}

