/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zzaf;
import com.google.android.gms.iid.zzai;
import com.google.android.gms.iid.zzaj;
import com.google.android.gms.iid.zzak;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Deprecated
public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    private static final zzaj<Boolean> zzbu = zzai.zzy().zzd("gcm_check_for_different_iid_in_token", true);
    private static Map<String, InstanceID> zzbv = new ArrayMap();
    private static final long zzbw = TimeUnit.DAYS.toMillis(7L);
    private static zzak zzbx;
    private static zzaf zzby;
    private static String zzbz;
    private Context zzl;
    private String zzca = "";

    @ShowFirstParty
    private InstanceID(Context context, String string) {
        this.zzl = context.getApplicationContext();
        this.zzca = string;
    }

    static int zzg(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzh(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    @Deprecated
    public static InstanceID getInstance(Context context) {
        return InstanceID.getInstance(context, null);
    }

    @KeepForSdk
    public static synchronized InstanceID getInstance(Context context, Bundle bundle) {
        Object object;
        String string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzbx == null) {
            object = context.getPackageName();
            Log.w((String)"InstanceID", (String)new StringBuilder(73 + String.valueOf(object).length()).append("Instance ID SDK is deprecated, ").append((String)object).append(" should update to use Firebase Instance ID").toString());
            zzbx = new zzak(context);
            zzby = new zzaf(context);
        }
        zzbz = Integer.toString(InstanceID.zzg(context));
        object = zzbv.get(string);
        if (object == null) {
            object = new InstanceID(context, string);
            zzbv.put(string, (InstanceID)object);
        }
        return object;
    }

    private final KeyPair getKeyPair() {
        return zzbx.zzj(this.zzca).getKeyPair();
    }

    @KeepForSdk
    public String getSubtype() {
        return this.zzca;
    }

    @Deprecated
    public String getId() {
        return InstanceID.zzd(this.getKeyPair());
    }

    static String zzd(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    @Deprecated
    public long getCreationTime() {
        return zzbx.zzj(this.zzca).getCreationTime();
    }

    @Deprecated
    public void deleteInstanceID() throws IOException {
        this.zzd("*", "*", null);
        this.zzo();
    }

    final void zzo() {
        zzbx.zzk(this.zzca);
    }

    @Deprecated
    public void deleteToken(String string, String string2) throws IOException {
        this.zzd(string, string2, null);
    }

    @ShowFirstParty
    public final void zzd(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzbx.zzh(this.zzca, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzca) ? string : this.zzca);
        bundle.putString("X-subtype", "".equals(this.zzca) ? string : this.zzca);
        zzaf.zzi(zzby.zzd(bundle, this.getKeyPair()));
    }

    public static zzak zzp() {
        return zzbx;
    }

    @Deprecated
    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    @Deprecated
    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        long l;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        String string3 = null;
        String string4 = string2;
        String string5 = string;
        InstanceID instanceID = this;
        String string6 = zzbx.get("appVersion");
        if (!(string6 == null || !string6.equals(zzbz) ? true : ((l = zzbx.zzg(instanceID.zzca, string5, string4)) < 0L ? true : System.currentTimeMillis() - l >= zzbw))) {
            string3 = zzbx.zzf(this.zzca, string, string2);
        }
        if (string3 == null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            string5 = string3 = this.zze(string, string2, bundle);
            instanceID = this;
            if (zzbu.get().booleanValue() && string5.contains(":") && !string5.startsWith(String.valueOf(instanceID.getId()).concat(":"))) {
                InstanceIDListenerService.zzd(instanceID.zzl, zzbx);
                throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            }
            if (string3 != null) {
                zzbx.zzd(this.zzca, string, string2, string3, zzbz);
            }
        }
        return string3;
    }

    public final String zze(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        String string4;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string5 = string4 = "".equals(this.zzca) ? string : this.zzca;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string4);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string4);
        }
        if ("RST".equals(string3 = zzaf.zzi(zzby.zzd(bundle, this.getKeyPair()))) || string3.startsWith("RST|")) {
            InstanceIDListenerService.zzd(this.zzl, zzbx);
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        return string3;
    }
}

