/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzaa;
import com.google.android.gms.iid.zzag;
import com.google.android.gms.iid.zzah;
import com.google.android.gms.iid.zzai;
import com.google.android.gms.iid.zzaj;
import com.google.android.gms.iid.zzr;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ShowFirstParty
public class zzaf {
    private static final zzaj<Boolean> zzct = zzai.zzy().zzd("gcm_iid_use_messenger_ipc", true);
    private static String zzcu = null;
    private static boolean zzcv = false;
    private static int zzcw = 0;
    private static int zzcx = 0;
    private static int zzcp = 0;
    @GuardedBy(value="Rpc.class")
    private static BroadcastReceiver zzcy = null;
    private Context zzl;
    private Map<String, Object> zzcz = new ArrayMap();
    private Messenger zzaj;
    private Messenger zzda;
    private MessengerCompat zzdb;
    private PendingIntent zzaf;

    public zzaf(Context context) {
        this.zzl = context;
    }

    @ShowFirstParty
    public static boolean zzk(Context context) {
        if (zzcu != null) {
            com.google.android.gms.iid.zzaf.zzl(context);
        }
        return zzcv;
    }

    @ShowFirstParty
    public static String zzl(Context context) {
        boolean bl;
        PackageManager packageManager;
        block9: {
            String string;
            Iterator iterator;
            PackageManager packageManager2;
            if (zzcu != null) {
                return zzcu;
            }
            zzcw = Process.myUid();
            packageManager = context.getPackageManager();
            if (!PlatformVersion.isAtLeastO()) {
                boolean bl2;
                block8: {
                    packageManager2 = packageManager;
                    iterator = packageManager2.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0).iterator();
                    while (iterator.hasNext()) {
                        string = ((ResolveInfo)iterator.next()).serviceInfo.packageName;
                        if (!com.google.android.gms.iid.zzaf.zzd(packageManager2, string, "com.google.android.c2dm.intent.REGISTER")) continue;
                        zzcv = false;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return zzcu;
                }
            }
            packageManager2 = packageManager;
            iterator = packageManager2.queryBroadcastReceivers(new Intent("com.google.iid.TOKEN_REQUEST"), 0).iterator();
            while (iterator.hasNext()) {
                string = ((ResolveInfo)iterator.next()).activityInfo.packageName;
                if (!com.google.android.gms.iid.zzaf.zzd(packageManager2, string, "com.google.iid.TOKEN_REQUEST")) continue;
                zzcv = true;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            return zzcu;
        }
        Log.w((String)"InstanceID", (String)"Failed to resolve IID implementation package, falling back");
        if (com.google.android.gms.iid.zzaf.zzd(packageManager, "com.google.android.gms")) {
            zzcv = PlatformVersion.isAtLeastO();
            return zzcu;
        }
        if (!PlatformVersion.isAtLeastLollipop() && com.google.android.gms.iid.zzaf.zzd(packageManager, "com.google.android.gsf")) {
            zzcv = false;
            return zzcu;
        }
        Log.w((String)"InstanceID", (String)"Google Play services is missing, unable to get tokens");
        return null;
    }

    private static boolean zzd(PackageManager packageManager, String string, String string2) {
        if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.SEND", string)) {
            return com.google.android.gms.iid.zzaf.zzd(packageManager, string);
        }
        Log.w((String)"InstanceID", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        return false;
    }

    private static boolean zzd(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            zzcu = applicationInfo.packageName;
            zzcx = applicationInfo.uid;
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static int zzm(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            return packageManager.getPackageInfo((String)com.google.android.gms.iid.zzaf.zzl((Context)context), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    public final void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzdb = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzda = (Messenger)parcelable;
                }
            }
            this.zzh((Intent)message.obj);
            return;
        }
        Log.w((String)"InstanceID", (String)"Dropping invalid message");
    }

    private final synchronized void zzg(Intent intent) {
        if (this.zzaf == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzaf = PendingIntent.getBroadcast((Context)this.zzl, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzaf);
    }

    static String zzi(Bundle bundle) throws IOException {
        if (bundle == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = bundle.getString("registration_id");
        if (string == null) {
            string = bundle.getString("unregistered");
        }
        if (string == null) {
            string = bundle.getString("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(bundle);
            Log.w((String)"InstanceID", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzcz.get(string);
            this.zzcz.put(string, object);
            com.google.android.gms.iid.zzaf.zzd(object2, object);
            return;
        }
    }

    private static void zzd(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            Message.obtain().obj = object2;
            try {
                messenger.send(message);
                return;
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string) && !"com.google.android.gms.iid.InstanceID".equals(string)) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            Intent intent2 = intent;
            zzaf zzaf2 = this;
            String string4 = intent2.getStringExtra("error");
            if (string4 == null) {
                String string5 = String.valueOf(intent2.getExtras());
                Log.w((String)"InstanceID", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                return;
            }
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string6 = String.valueOf(string4);
                Log.d((String)"InstanceID", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
            }
            String string7 = null;
            if (string4.startsWith("|")) {
                String[] stringArray = string4.split("\\|");
                if (!"ID".equals(stringArray[1])) {
                    String string8 = String.valueOf(string4);
                    Log.w((String)"InstanceID", (String)(string8.length() != 0 ? "Unexpected structured response ".concat(string8) : new String("Unexpected structured response ")));
                }
                if (stringArray.length > 2) {
                    string7 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                } else {
                    string4 = "UNKNOWN";
                }
                intent2.putExtra("error", string4);
            }
            if (string7 == null) {
                String string9 = string4;
                zzaf zzaf3 = zzaf2;
                Class<?> clazz = zzaf3.getClass();
                synchronized (clazz) {
                    for (String string10 : zzaf3.zzcz.keySet()) {
                        Object object = zzaf3.zzcz.get(string10);
                        zzaf3.zzcz.put(string10, string9);
                        com.google.android.gms.iid.zzaf.zzd(object, (Object)string9);
                    }
                    return;
                }
            }
            zzaf2.zzd(string7, string4);
            return;
        }
        Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
        if (!matcher.matches()) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string11 = String.valueOf(string3);
                Log.d((String)"InstanceID", (String)(string11.length() != 0 ? "Unexpected response string: ".concat(string11) : new String("Unexpected response string: ")));
            }
            return;
        }
        String string12 = matcher.group(1);
        String string13 = matcher.group(2);
        Bundle bundle = intent.getExtras();
        bundle.putString("registration_id", string13);
        this.zzd(string12, bundle);
    }

    final Bundle zzd(Bundle bundle, KeyPair keyPair) throws IOException {
        int n;
        int n2 = n = com.google.android.gms.iid.zzaf.zzm(this.zzl);
        KeyPair keyPair2 = keyPair;
        Bundle bundle2 = bundle;
        zzaf zzaf2 = this;
        bundle2.putString("gmsv", Integer.toString(n2));
        bundle2.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle2.putString("app_ver", Integer.toString(InstanceID.zzg(zzaf2.zzl)));
        bundle2.putString("app_ver_name", InstanceID.zzh(zzaf2.zzl));
        bundle2.putString("cliv", "iid-12451000");
        bundle2.putString("appid", InstanceID.zzd(keyPair2));
        if (n >= 12000000 && zzct.get().booleanValue()) {
            Task<Bundle> task = new zzr(this.zzl).zzd(1, bundle);
            try {
                return (Bundle)Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable((String)"InstanceID", (int)3)) {
                    String string = String.valueOf(exception);
                    Log.d((String)"InstanceID", (String)new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
                }
                if (exception.getCause() instanceof zzaa && ((zzaa)exception.getCause()).getErrorCode() == 4) {
                    return this.zzj(bundle);
                }
                return null;
            }
        }
        return this.zzj(bundle);
    }

    private final Bundle zzj(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zzk(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zzk(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zzx() {
        return Integer.toString(zzcp++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final Bundle zzk(Bundle bundle) throws IOException {
        Class<?> clazz;
        String string;
        ConditionVariable conditionVariable;
        block24: {
            String string2;
            boolean bl;
            Intent intent;
            zzaf zzaf2;
            block25: {
                zzaf zzaf3;
                conditionVariable = new ConditionVariable();
                string = com.google.android.gms.iid.zzaf.zzx();
                clazz = this.getClass();
                // MONITORENTER : clazz
                this.zzcz.put(string, conditionVariable);
                // MONITOREXIT : clazz
                String string3 = string;
                Bundle bundle2 = bundle;
                zzaf2 = zzaf3 = this;
                if (zzaf3.zzaj == null) {
                    com.google.android.gms.iid.zzaf.zzl(zzaf2.zzl);
                    zzaf2.zzaj = new Messenger((Handler)new zzag(zzaf2, Looper.getMainLooper()));
                }
                if (zzcu == null) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent(zzcv ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
                intent2.setPackage(zzcu);
                intent2.putExtras(bundle2);
                zzaf3.zzg(intent2);
                String string4 = string3;
                intent = intent2;
                zzaf2 = zzaf3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                bl = "com.google.android.gsf".equals(zzcu);
                String string5 = intent.getStringExtra("useGsf");
                if (string5 != null) {
                    bl = "1".equals(string5);
                }
                if (Log.isLoggable((String)"InstanceID", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"InstanceID", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                if (zzaf2.zzda != null) {
                    intent.putExtra("google.messenger", (Parcelable)zzaf2.zzaj);
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        zzaf2.zzda.send((Message)string2);
                        break block24;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"InstanceID", (int)3)) break block25;
                        Log.d((String)"InstanceID", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (bl) {
                zzaf zzaf4 = zzaf2;
                Class<zzaf> clazz2 = zzaf.class;
                // MONITORENTER : com.google.android.gms.iid.zzaf.class
                if (zzcy == null) {
                    zzcy = new zzah(zzaf4);
                    if (Log.isLoggable((String)"InstanceID", (int)3)) {
                        Log.d((String)"InstanceID", (String)"Registered GSF callback receiver");
                    }
                    IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
                    intentFilter.addCategory(zzaf4.zzl.getPackageName());
                    zzaf4.zzl.registerReceiver(zzcy, intentFilter, "com.google.android.c2dm.permission.SEND", null);
                }
                // MONITOREXIT : clazz2
                zzaf2.zzl.sendBroadcast(intent);
            } else {
                block26: {
                    intent.putExtra("google.messenger", (Parcelable)zzaf2.zzaj);
                    intent.putExtra("messenger2", "1");
                    if (zzaf2.zzdb != null) {
                        string2 = Message.obtain();
                        Message.obtain().obj = intent;
                        try {
                            zzaf2.zzdb.send((Message)string2);
                            break block24;
                        }
                        catch (RemoteException remoteException) {
                            if (!Log.isLoggable((String)"InstanceID", (int)3)) break block26;
                            Log.d((String)"InstanceID", (String)"Messenger failed, fallback to startService");
                        }
                    }
                }
                if (zzcv) {
                    zzaf2.zzl.sendBroadcast(intent);
                } else {
                    zzaf2.zzl.startService(intent);
                }
            }
        }
        conditionVariable.block(30000L);
        clazz = this.getClass();
        // MONITORENTER : clazz
        Object object = this.zzcz.remove(string);
        if (object instanceof Bundle) {
            // MONITOREXIT : clazz
            return (Bundle)object;
        }
        if (object instanceof String) {
            throw new IOException((String)object);
        }
        String string6 = String.valueOf(object);
        Log.w((String)"InstanceID", (String)new StringBuilder(12 + String.valueOf(string6).length()).append("No response ").append(string6).toString());
        throw new IOException("TIMEOUT");
    }
}

