/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.MessengerCompat;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class zzc {
    static String zzaUq = null;
    static int zzaUr = 0;
    static int zzaUs = 0;
    static int zzaUt = 0;
    Context zzov;
    Map<String, Object> zzaUu = new HashMap<String, Object>();
    Messenger zzaTe;
    Messenger zzaUv;
    MessengerCompat zzaUw;
    PendingIntent zzaTa;
    long zzaUx;
    long zzaUy;
    int zzaUz;
    int zzaUA;
    long zzaUB;

    public zzc(Context context) {
        this.zzov = context;
    }

    public static String zzaX(Context context) {
        if (zzaUq != null) {
            return zzaUq;
        }
        zzaUr = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string;
            if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", resolveInfo.serviceInfo.packageName)) {
                try {
                    string = packageManager.getApplicationInfo(resolveInfo.serviceInfo.packageName, 0);
                    int n = ((ApplicationInfo)string).uid;
                    Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(17).append("Found ").append(n).toString());
                    zzaUs = ((ApplicationInfo)string).uid;
                    zzaUq = resolveInfo.serviceInfo.packageName;
                    return zzaUq;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    continue;
                }
            }
            string = String.valueOf(resolveInfo.serviceInfo.packageName);
            String string2 = String.valueOf("com.google.android.c2dm.intent.REGISTER");
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve REGISTER intent, falling back");
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            zzaUq = applicationInfo.packageName;
            zzaUs = applicationInfo.uid;
            return zzaUq;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gsf", 0);
                zzaUq = applicationInfo.packageName;
                zzaUs = applicationInfo.uid;
                return zzaUq;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                Log.w((String)"InstanceID/Rpc", (String)"Both Google Play Services and legacy GSF package are missing");
                return null;
            }
        }
    }

    private static int zzaY(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(zzc.zzaX(context), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return InstanceID.zzp(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzCi() {
        if (this.zzaTe != null) {
            return;
        }
        zzc.zzaX(this.zzov);
        this.zzaTe = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                zzc.this.zze(message);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzaUw = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzaUv = (Messenger)parcelable;
                }
            }
            this.zzu((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzr(Intent intent) {
        if (this.zzaTa == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzaTa = PendingIntent.getBroadcast((Context)this.zzov, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzaTa);
    }

    void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzaUB != 0L && l <= this.zzaUB) {
            long l2 = this.zzaUB - l;
            int n = this.zzaUA;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
            throw new IOException("RETRY_LATER");
        }
        this.zzCi();
        if (zzaUq == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.zzaUx = SystemClock.elapsedRealtime();
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzaUq);
        int n = zzc.zzaY(this.zzov);
        bundle.putString("gmsv", Integer.toString(n));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(InstanceID.zzaU(this.zzov)));
        bundle.putString("app_ver_name", InstanceID.zzaV(this.zzov));
        bundle.putString("cliv", "1");
        bundle.putString("appid", InstanceID.zza(keyPair));
        String string2 = InstanceID.zzp(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string2);
        bundle.putString("sig", zzc.zza(keyPair, this.zzov.getPackageName(), string2));
        intent.putExtras(bundle);
        this.zzr(intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        String string2;
        boolean bl;
        block10: {
            this.zzaUx = SystemClock.elapsedRealtime();
            intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            bl = "com.google.android.gsf".equals(zzaUq);
            String string3 = intent.getStringExtra("useGsf");
            if (string3 != null) {
                bl = "1".equals(string3);
            }
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                string2 = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            if (this.zzaUv != null) {
                intent.putExtra("google.messenger", (Parcelable)this.zzaTe);
                string2 = Message.obtain();
                ((Message)string2).obj = intent;
                try {
                    this.zzaUv.send((Message)string2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block10;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        if (bl) {
            string2 = new Intent("com.google.android.gms.iid.InstanceID");
            string2.setPackage(this.zzov.getPackageName());
            string2.putExtra("GSF", (Parcelable)intent);
            this.zzov.startService((Intent)string2);
        } else {
            block11: {
                intent.putExtra("google.messenger", (Parcelable)this.zzaTe);
                intent.putExtra("messenger2", "1");
                if (this.zzaUw != null) {
                    string2 = Message.obtain();
                    ((Message)string2).obj = intent;
                    try {
                        this.zzaUw.send((Message)string2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block11;
                        Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            this.zzov.startService(intent);
        }
    }

    String zzs(Intent intent) throws IOException {
        boolean bl;
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        boolean bl2 = bl = string != null;
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzt(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        String string4 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            if (stringArray.length > 2) {
                string4 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        if (null == string4) {
            this.zzF(string);
        } else {
            this.zzi(string4, string);
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.zzaUy = SystemClock.elapsedRealtime();
            this.zzaUA = (int)l * 1000;
            this.zzaUB = SystemClock.elapsedRealtime() + (long)this.zzaUA;
            int n = this.zzaUA;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzeB(string);
        }
    }

    private void zzeB(String string) {
        if (!"com.google.android.gsf".equals(zzaUq)) {
            return;
        }
        ++this.zzaUz;
        if (this.zzaUz < 3) {
            return;
        }
        if (this.zzaUz == 3) {
            this.zzaUA = 1000 + new Random().nextInt(1000);
        }
        this.zzaUA *= 2;
        this.zzaUB = SystemClock.elapsedRealtime() + (long)this.zzaUA;
        int n = this.zzaUA;
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Backoff due to ").append(string).append(" for ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzF(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.zzaUu.keySet()) {
                Object object2 = this.zzaUu.get(string);
                this.zzaUu.put(string, object);
                this.zzh(object2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzaUu.get(string);
            this.zzaUu.put(string, object);
            this.zzh(object2, object);
        }
    }

    private void zzh(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            message.obj = object2;
            try {
                messenger.send(message);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    public void zzu(Intent intent) {
        String[] stringArray;
        String string;
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string2) && !"com.google.android.gms.iid.InstanceID".equals(string2)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string3 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Unexpected response ".concat(string3) : new String("Unexpected response ")));
            }
            return;
        }
        String string4 = intent.getStringExtra("registration_id");
        if (string4 == null) {
            string4 = intent.getStringExtra("unregistered");
        }
        if (string4 == null) {
            this.zzt(intent);
            return;
        }
        this.zzaUx = SystemClock.elapsedRealtime();
        this.zzaUB = 0L;
        this.zzaUz = 0;
        this.zzaUA = 0;
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            string = string4;
            stringArray = String.valueOf(intent.getExtras());
            Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(stringArray).length()).append("AppIDResponse: ").append(string).append(" ").append((String)stringArray).toString());
        }
        string = null;
        if (string4.startsWith("|")) {
            stringArray = string4.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string4);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            string = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    InstanceIDListenerService.zzaW(this.zzov);
                } else if ("RST".equals(stringArray[3])) {
                    InstanceIDListenerService.zza(this.zzov, InstanceID.getInstance(this.zzov).zzCf());
                    intent.removeExtra("registration_id");
                    this.zzi(string, intent);
                    return;
                }
            }
            if ((string4 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string4 = string4.substring(1);
            }
            intent.putExtra("registration_id", string4);
        }
        if (null == string) {
            this.zzF(intent);
        } else {
            this.zzi(string, intent);
        }
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger")) {
            intent = this.zzb(bundle, keyPair);
        }
        return intent;
    }

    public static synchronized String zzCj() {
        return Integer.toString(zzaUt++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string = zzc.zzCj();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.zzaUu.put(string, conditionVariable);
        }
        this.zza(bundle, keyPair, string);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.zzaUu.remove(string);
            if (object instanceof Intent) {
                return (Intent)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            String string2 = String.valueOf(object);
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(12 + String.valueOf(string2).length()).append("No response ").append(string2).toString());
            throw new IOException("TIMEOUT");
        }
    }
}

