/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.zzaqi;
import com.google.android.gms.internal.zzarc;

public class zzaqr {
    private static Boolean zzbif = null;
    private static ContentProviderClient zzbig;

    @TargetApi(value=11)
    private static Intent zza(Context context, String string, Parcelable parcelable, boolean bl) {
        Bundle bundle;
        if (context == null || string == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        if (!zzaqr.zzbl(context)) {
            return null;
        }
        Bundle bundle2 = null;
        if (parcelable != null) {
            bundle2 = new Bundle(1);
            bundle2.putParcelable("key_fallbackIntent", parcelable);
        }
        try {
            bundle = zzaqr.zza(context, "method_getInstantAppIntent", string, bundle2);
        }
        catch (DeadObjectException deadObjectException) {
            Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzaqi.zzbhS, "method_getInstantAppIntent"), (Throwable)deadObjectException);
            zzaqr.reset();
            if (bl) {
                return zzaqr.zza(context, string, parcelable, false);
            }
            return null;
        }
        catch (RemoteException | IllegalArgumentException throwable) {
            Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzaqi.zzbhS, "method_getInstantAppIntent"), (Throwable)throwable);
            return null;
        }
        if (bundle == null) {
            return null;
        }
        return (Intent)bundle.getParcelable("key_instantAppIntent");
    }

    @TargetApi(value=17)
    private static synchronized boolean zzbk(Context context) {
        if (zzbig == null) {
            zzbig = context.getApplicationContext().getContentResolver().acquireUnstableContentProviderClient(zzaqi.zzbhS);
        }
        return zzbig != null;
    }

    @TargetApi(value=17)
    private static synchronized Bundle zzd(String string, String string2, Bundle bundle) throws RemoteException {
        return zzbig.call(string, string2, bundle);
    }

    @TargetApi(value=11)
    private static synchronized Bundle zza(Context context, String string, String string2, Bundle bundle) throws RemoteException {
        if (zzbig == null) {
            return context.getContentResolver().call(zzaqi.zzbhS, string, string2, bundle);
        }
        return zzaqr.zzd(string, string2, bundle);
    }

    static Intent getInstantAppIntent(Context context, String string, Intent intent) {
        return zzaqr.zza(context, string, (Parcelable)intent, true);
    }

    @TargetApi(value=11)
    static synchronized boolean zzbl(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        if (zzbif != null) {
            return zzbif;
        }
        zzbif = zzaqr.zzbm(context);
        return zzbif;
    }

    private static synchronized boolean zzbm(Context context) {
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        if (!zzarc.zzbp(context)) {
            return false;
        }
        ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(zzaqi.zzbhS.getAuthority(), 0);
        if (providerInfo == null) {
            return false;
        }
        if (!providerInfo.packageName.equals("com.google.android.gms")) {
            String string = String.valueOf(providerInfo.packageName);
            Log.e((String)"InstantAppsApi", (String)(string.length() != 0 ? "Incorrect package name for instant apps content provider: ".concat(string) : new String("Incorrect package name for instant apps content provider: ")));
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || zzaqr.zzbk(context);
    }

    static synchronized void reset() {
        if (zzbig != null) {
            zzbig.release();
            zzbig = null;
        }
        zzbif = null;
    }
}

