/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.zzcbq;
import com.google.android.gms.internal.zzcbs;

public final class zzcbp {
    private static zzcbp zzbhq;
    private final Context mContext;

    @Nullable
    public static synchronized zzcbp zzbf(Context context) {
        if (zzbhq == null) {
            zzcbp zzcbp2;
            Context context2 = context.getApplicationContext();
            if (!(Build.VERSION.SDK_INT >= 16)) {
                zzcbp2 = null;
            } else if (!zzcbs.zzbg(context2)) {
                zzcbp2 = null;
            } else {
                ProviderInfo providerInfo = context2.getPackageManager().resolveContentProvider(zzcbq.zzbhr.getAuthority(), 0);
                if (providerInfo == null) {
                    zzcbp2 = null;
                } else if (!providerInfo.packageName.equals("com.google.android.gms")) {
                    String string = String.valueOf(providerInfo.packageName);
                    Log.e((String)"IAMetadataClient", (String)new StringBuilder(85 + String.valueOf(string).length()).append("Package ").append(string).append(" is invalid for instant apps content provider; instant apps will be disabled.").toString());
                    zzcbp2 = null;
                } else {
                    zzcbp2 = new zzcbp(context2);
                }
            }
            zzbhq = zzcbp2;
        }
        return zzbhq;
    }

    private zzcbp(Context context) {
        this.mContext = context;
    }

    @TargetApi(value=16)
    private final Bundle zzg(String string, Bundle bundle) throws RemoteException {
        Bundle bundle2;
        long l = Binder.clearCallingIdentity();
        try {
            bundle2 = this.mContext.getContentResolver().call(zzcbq.zzbhr, string, null, bundle);
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
        }
        if (bundle2 == null) {
            throw new RemoteException();
        }
        return bundle2;
    }

    public final String zzbi(int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        return this.zzg("getAppPackageForUid", bundle).getString("result");
    }

    public final ApplicationInfo getApplicationInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (ApplicationInfo)this.zzg("getWHApplicationInfo", bundle).getParcelable("result");
    }

    public final PackageInfo getPackageInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (PackageInfo)this.zzg("getWHPackageInfo", bundle).getParcelable("result");
    }

    public final String zzdt(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzg("getApplicationLabel", bundle).getString("result");
    }

    public final ComponentName zzdu(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("shadowActivity", string);
        return (ComponentName)this.zzg("getCallingActivity", bundle).getParcelable("result");
    }

    public final boolean isInstantApp(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzg("isInstantApp", bundle).getBoolean("result");
    }
}

