/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.location.zzm;

public final class LocationRequest
extends zza
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    int mPriority;
    long zzbjY;
    long zzbjZ;
    boolean zzaWy;
    long zzbjI;
    int zzbka;
    float zzbkb;
    long zzbkc;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzm();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzbjY = 3600000L;
        this.zzbjZ = 600000L;
        this.zzaWy = false;
        this.zzbjI = Long.MAX_VALUE;
        this.zzbka = Integer.MAX_VALUE;
        this.zzbkb = 0.0f;
        this.zzbkc = 0L;
    }

    public LocationRequest setPriority(int n) {
        LocationRequest.zzkk(n);
        this.mPriority = n;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long l) {
        LocationRequest.zzV(l);
        this.zzbjY = l;
        if (!this.zzaWy) {
            this.zzbjZ = (long)((double)this.zzbjY / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzbjY;
    }

    public LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzV(l);
        this.zzbkc = l;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzbkc;
        if (l < this.zzbjY) {
            l = this.zzbjY;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long l) {
        LocationRequest.zzV(l);
        this.zzaWy = true;
        this.zzbjZ = l;
        return this;
    }

    public long getFastestInterval() {
        return this.zzbjZ;
    }

    public LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzbjI = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzbjI < 0L) {
            this.zzbjI = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long l) {
        this.zzbjI = l;
        if (this.zzbjI < 0L) {
            this.zzbjI = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzbjI;
    }

    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzbka = n;
        return this;
    }

    public int getNumUpdates() {
        return this.zzbka;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        LocationRequest.zze(f);
        this.zzbkb = f;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzbkb;
    }

    private static void zzV(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    private static void zzkk(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
    }

    private static void zze(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzbjY = l;
        this.zzbjZ = l2;
        this.zzaWy = bl;
        this.zzbjI = l3;
        this.zzbka = n2;
        this.zzbkb = f;
        this.zzbkc = l4;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public static String zzkl(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzkl(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzbjY).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzbjZ).append("ms");
        if (this.zzbkc > this.zzbjY) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzbkc).append("ms");
        }
        if (this.zzbkb > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzbkb).append("m");
        }
        if (this.zzbjI != Long.MAX_VALUE) {
            long l = this.zzbjI - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzbka != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzbka);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.mPriority, this.zzbjY, Float.valueOf(this.zzbkb), this.zzbkc});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzbjY == locationRequest.zzbjY && this.zzbjZ == locationRequest.zzbjZ && this.zzaWy == locationRequest.zzaWy && this.zzbjI == locationRequest.zzbjI && this.zzbka == locationRequest.zzbka && this.zzbkb == locationRequest.zzbkb && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

