/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzasn;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public class zzasm
extends zza
implements Geofence {
    private final String zzOV;
    private final long zzbkT;
    private final short zzbjE;
    private final double zzbjF;
    private final double zzbjG;
    private final float zzbjH;
    private final int zzbjC;
    private final int zzbjI;
    private final int zzbjJ;
    public static final Parcelable.Creator<zzasm> CREATOR = new zzasn();

    public zzasm(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        zzasm.zzeT(string);
        zzasm.zzf(f);
        zzasm.zza(d, d2);
        n = zzasm.zzkA(n);
        this.zzbjE = s;
        this.zzOV = string;
        this.zzbjF = d;
        this.zzbjG = d2;
        this.zzbjH = f;
        this.zzbkT = l;
        this.zzbjC = n;
        this.zzbjI = n2;
        this.zzbjJ = n3;
    }

    public short zzIu() {
        return this.zzbjE;
    }

    public double getLatitude() {
        return this.zzbjF;
    }

    public double getLongitude() {
        return this.zzbjG;
    }

    public float getRadius() {
        return this.zzbjH;
    }

    @Override
    public String getRequestId() {
        return this.zzOV;
    }

    public long getExpirationTime() {
        return this.zzbkT;
    }

    public int zzIv() {
        return this.zzbjC;
    }

    public int zzIw() {
        return this.zzbjI;
    }

    public int zzIx() {
        return this.zzbjJ;
    }

    private static void zzeT(String string) {
        if (string == null || string.length() > 100) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "requestId is null or too long: ".concat(string2) : new String("requestId is null or too long: "));
        }
    }

    private static void zzf(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f).toString());
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d).toString());
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d2).toString());
        }
    }

    private static int zzkA(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n).toString());
        }
        return n2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzasn.zza(this, parcel, n);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String zzkB(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static zzasm zzw(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzasm zzasm2 = (zzasm)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzasm2;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", zzasm.zzkB(this.zzbjE), this.zzOV, this.zzbjC, this.zzbjF, this.zzbjG, Float.valueOf(this.zzbjH), this.zzbjI / 1000, this.zzbjJ, this.zzbkT);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.zzbjF);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzbjG);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + Float.floatToIntBits(this.zzbjH);
        n = 31 * n + this.zzbjE;
        n = 31 * n + this.zzbjC;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzasm)) {
            return false;
        }
        zzasm zzasm2 = (zzasm)object;
        if (this.zzbjH != zzasm2.zzbjH) {
            return false;
        }
        if (this.zzbjF != zzasm2.zzbjF) {
            return false;
        }
        if (this.zzbjG != zzasm2.zzbjG) {
            return false;
        }
        return this.zzbjE == zzasm2.zzbjE;
    }
}

