/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzc;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<ActivityRecognitionResult> CREATOR = new zzc();
    List<DetectedActivity> zzbjp;
    long zzbjq;
    long zzbjr;
    int zzbjs;
    Bundle extras;

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2) {
        this(list, l, l2, 0, null);
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2) {
        this(detectedActivity, l, l2, 0, null);
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2, int n, Bundle bundle) {
        this(Collections.singletonList(detectedActivity), l, l2, n, bundle);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        if (ActivityRecognitionResult.zzt(intent)) {
            return true;
        }
        List<ActivityRecognitionResult> list = ActivityRecognitionResult.zzw(intent);
        return list != null && !list.isEmpty();
    }

    private static boolean zzt(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        ActivityRecognitionResult activityRecognitionResult = ActivityRecognitionResult.zzu(intent);
        if (activityRecognitionResult != null) {
            return activityRecognitionResult;
        }
        List<ActivityRecognitionResult> list = ActivityRecognitionResult.zzw(intent);
        return list == null || list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private static ActivityRecognitionResult zzu(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        Object object = intent.getExtras().get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
        if (object instanceof byte[]) {
            return (ActivityRecognitionResult)zzd.zza((byte[])((byte[])object), CREATOR);
        }
        if (object instanceof ActivityRecognitionResult) {
            return (ActivityRecognitionResult)((Object)object);
        }
        return null;
    }

    public static boolean zzv(@Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST");
    }

    @Nullable
    public static List<ActivityRecognitionResult> zzw(Intent intent) {
        if (!ActivityRecognitionResult.zzv(intent)) {
            return null;
        }
        return zzd.zzb((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST", CREATOR);
    }

    public DetectedActivity getMostProbableActivity() {
        return this.zzbjp.get(0);
    }

    public int getActivityConfidence(int n) {
        for (DetectedActivity detectedActivity : this.zzbjp) {
            if (detectedActivity.getType() != n) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.zzbjp;
    }

    public long getTime() {
        return this.zzbjq;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzbjr;
    }

    public String toString() {
        String string = String.valueOf(this.zzbjp);
        long l = this.zzbjq;
        long l2 = this.zzbjr;
        return new StringBuilder(124 + String.valueOf(string).length()).append("ActivityRecognitionResult [probableActivities=").append(string).append(", timeMillis=").append(l).append(", elapsedRealtimeMillis=").append(l2).append("]").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object);
        return this.zzbjq == activityRecognitionResult.zzbjq && this.zzbjr == activityRecognitionResult.zzbjr && this.zzbjs == activityRecognitionResult.zzbjs && zzaa.equal(this.zzbjp, activityRecognitionResult.zzbjp) && ActivityRecognitionResult.zzc(this.extras, activityRecognitionResult.extras);
    }

    private static boolean zzc(Bundle bundle, Bundle bundle2) {
        if (bundle == null && bundle2 == null) {
            return true;
        }
        if (bundle == null && bundle2 != null || bundle != null && bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            if (!(bundle.get(string) == null ? bundle2.get(string) != null : (bundle.get(string) instanceof Bundle ? !ActivityRecognitionResult.zzc(bundle.getBundle(string), bundle2.getBundle(string)) : !bundle.get(string).equals(bundle2.get(string))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzbjq, this.zzbjr, this.zzbjs, this.zzbjp, this.extras});
    }

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2, int n, Bundle bundle) {
        zzac.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        zzac.zzb((l > 0L && l2 > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.zzbjp = list;
        this.zzbjq = l;
        this.zzbjr = l2;
        this.zzbjs = n;
        this.extras = bundle;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }
}

