/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.zzasm;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzOV = null;
        private int zzbjC = 0;
        private long zzbjD = Long.MIN_VALUE;
        private short zzbjE = (short)-1;
        private double zzbjF;
        private double zzbjG;
        private float zzbjH;
        private int zzbjI = 0;
        private int zzbjJ = -1;

        public Builder setRequestId(String string) {
            this.zzOV = string;
            return this;
        }

        public Builder setTransitionTypes(int n) {
            this.zzbjC = n;
            return this;
        }

        public Builder setExpirationDuration(long l) {
            this.zzbjD = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public Builder setCircularRegion(double d, double d2, float f) {
            this.zzbjE = 1;
            this.zzbjF = d;
            this.zzbjG = d2;
            this.zzbjH = f;
            return this;
        }

        public Builder setNotificationResponsiveness(int n) {
            this.zzbjI = n;
            return this;
        }

        public Builder setLoiteringDelay(int n) {
            this.zzbjJ = n;
            return this;
        }

        public Geofence build() {
            if (this.zzOV == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzbjC == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzbjC & 4) != 0 && this.zzbjJ < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzbjD == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzbjE == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzbjI < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzasm(this.zzOV, this.zzbjC, 1, this.zzbjF, this.zzbjG, this.zzbjH, this.zzbjD, this.zzbjI, this.zzbjJ);
        }
    }
}

